/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.spring.utils.ConditionalOnRdbmsDisabled;
import io.camunda.tasklist.exceptions.NotFoundException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.store.DraftVariableStore;
import io.camunda.tasklist.store.TaskStore;
import io.camunda.tasklist.store.VariableStore;
import io.camunda.tasklist.webapp.api.rest.v1.entities.VariableResponse;
import io.camunda.tasklist.webapp.api.rest.v1.entities.VariableSearchResponse;
import io.camunda.tasklist.webapp.dto.VariableDTO;
import io.camunda.tasklist.webapp.dto.VariableInputDTO;
import io.camunda.tasklist.webapp.es.TaskValidator;
import io.camunda.tasklist.webapp.rest.exception.InvalidRequestException;
import io.camunda.tasklist.webapp.rest.exception.NotFoundApiException;
import io.camunda.webapps.schema.entities.VariableEntity;
import io.camunda.webapps.schema.entities.flownode.FlowNodeInstanceEntity;
import io.camunda.webapps.schema.entities.usertask.DraftTaskVariableEntity;
import io.camunda.webapps.schema.entities.usertask.SnapshotTaskVariableEntity;
import io.camunda.webapps.schema.entities.usertask.TaskEntity;
import io.camunda.webapps.schema.entities.usertask.TaskState;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnRdbmsDisabled
public class VariableService {
    private static final Logger LOGGER = LoggerFactory.getLogger(VariableService.class);
    private static final String ABSENT_PARENT_ID = "-1";
    @Autowired
    private TaskStore taskStore;
    @Autowired
    private VariableStore variableStore;
    @Autowired
    private DraftVariableStore draftVariableStore;
    @Autowired
    private TasklistProperties tasklistProperties;
    @Autowired
    private TaskValidator taskValidator;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;

    public void persistDraftTaskVariables(String taskId, List<VariableInputDTO> draftTaskVariables) {
        try {
            TaskEntity task = this.taskStore.getTask(taskId);
            this.taskValidator.validateCanPersistDraftTaskVariables(task);
            this.validateVariableInputs(draftTaskVariables);
            long deletedDraftVariablesCount = this.draftVariableStore.deleteAllByTaskId(taskId);
            LOGGER.debug("'{}' draft task variables associated with task id '{}' were deleted", (Object)deletedDraftVariablesCount, (Object)task);
            if (CollectionUtils.isEmpty(draftTaskVariables)) {
                return;
            }
            HashMap currentOriginalVariables = new HashMap();
            this.getRuntimeVariablesByRequest(VariableStore.GetVariablesRequest.createFrom((TaskEntity)task)).forEach(originalVar -> currentOriginalVariables.put(originalVar.getName(), originalVar));
            int variableSizeThreshold = this.tasklistProperties.getImporter().getVariableSizeThreshold();
            HashMap toPersist = new HashMap();
            draftTaskVariables.forEach(draftVariable -> {
                if (currentOriginalVariables.containsKey(draftVariable.getName())) {
                    String fullValue;
                    VariableEntity variableEntity = (VariableEntity)currentOriginalVariables.get(draftVariable.getName());
                    String string = fullValue = variableEntity.getIsPreview() ? variableEntity.getFullValue() : variableEntity.getValue();
                    if (!fullValue.equals(draftVariable.getValue())) {
                        toPersist.put(draftVariable.getName(), VariableService.createDraftVariableFrom(variableEntity.getId(), task, draftVariable.getName(), draftVariable.getValue(), variableSizeThreshold));
                    }
                } else {
                    toPersist.put(draftVariable.getName(), VariableService.createDraftVariableFrom(task, draftVariable.getName(), draftVariable.getValue(), variableSizeThreshold));
                }
            });
            this.draftVariableStore.createOrUpdate(toPersist.values());
        }
        catch (NotFoundException e) {
            throw new NotFoundApiException("Task not found", e);
        }
    }

    private void validateVariableInputs(Collection<VariableInputDTO> variable) {
        variable.stream().map(VariableInputDTO::getValue).forEach(value -> {
            try {
                this.objectMapper.readValue(value, Object.class);
            }
            catch (IOException e) {
                throw new InvalidRequestException(e.getMessage(), e);
            }
        });
    }

    public void persistTaskVariables(String taskId, List<VariableInputDTO> changedVariables, boolean withDraftVariableValues) {
        TaskEntity task = this.taskStore.getTask(taskId);
        long processInstanceKey = Long.parseLong(task.getProcessInstanceId());
        List<VariableEntity> taskVariables = this.getRuntimeVariablesByRequest(VariableStore.GetVariablesRequest.createFrom((TaskEntity)task));
        HashMap<String, SnapshotTaskVariableEntity> finalVariablesMap = new HashMap<String, SnapshotTaskVariableEntity>();
        taskVariables.forEach(variable -> finalVariablesMap.put(variable.getName(), VariableService.createSnapshotVariableFrom(taskId, variable)));
        if (withDraftVariableValues) {
            this.draftVariableStore.getVariablesByTaskIdAndVariableNames(taskId, Collections.emptyList()).forEach(draftTaskVariable -> finalVariablesMap.put(draftTaskVariable.getName(), VariableService.createSnapshotVariableFrom(taskId, processInstanceKey, draftTaskVariable)));
        }
        for (VariableInputDTO var : changedVariables) {
            finalVariablesMap.put(var.getName(), VariableService.createSnapshotVariableFrom(task.getTenantId(), taskId, processInstanceKey, var.getName(), var.getValue(), this.tasklistProperties.getImporter().getVariableSizeThreshold()));
        }
        this.variableStore.persistTaskVariables(finalVariablesMap.values());
    }

    public void deleteDraftTaskVariables(String taskId) {
        this.draftVariableStore.deleteAllByTaskId(taskId);
    }

    private List<VariableEntity> getRuntimeVariablesByRequest(VariableStore.GetVariablesRequest getVariablesRequest) {
        List<VariableStore.GetVariablesRequest> requests = Collections.singletonList(getVariablesRequest);
        Map<String, List<VariableEntity>> runtimeVariablesPerTaskId = this.getRuntimeVariablesPerTaskId(requests);
        if (runtimeVariablesPerTaskId.size() > 0) {
            return runtimeVariablesPerTaskId.values().iterator().next();
        }
        return new ArrayList<VariableEntity>();
    }

    private List<VariableEntity> getRuntimeVariablesDTOPerTaskId(List<VariableStore.GetVariablesRequest> requests) {
        Map<String, List<VariableEntity>> variablesByTaskIds = this.getRuntimeVariablesPerTaskId(requests);
        if (variablesByTaskIds.size() > 0) {
            return variablesByTaskIds.values().iterator().next();
        }
        return new ArrayList<VariableEntity>();
    }

    private Map<String, List<VariableEntity>> getRuntimeVariablesPerTaskId(List<VariableStore.GetVariablesRequest> requests) {
        if (requests == null || requests.size() == 0) {
            return new HashMap<String, List<VariableEntity>>();
        }
        Map<String, VariableStore.FlowNodeTree> flowNodeTrees = this.buildFlowNodeTrees(requests);
        List<String> flowNodeInstanceIds = flowNodeTrees.values().stream().flatMap(f -> f.getFlowNodeInstanceIds().stream()).collect(Collectors.toList());
        Map<String, VariableStore.VariableMap> variableMaps = this.buildVariableMaps(flowNodeInstanceIds, requests.stream().map(VariableStore.GetVariablesRequest::getVarNames).filter(Objects::nonNull).flatMap(Collection::stream).distinct().collect(Collectors.toList()), requests.get(0).getFieldNames());
        return this.buildResponse(flowNodeTrees, variableMaps, requests);
    }

    private Map<String, List<VariableEntity>> buildResponse(Map<String, VariableStore.FlowNodeTree> flowNodeTrees, Map<String, VariableStore.VariableMap> variableMaps, List<VariableStore.GetVariablesRequest> requests) {
        HashMap<String, List<VariableEntity>> response = new HashMap<String, List<VariableEntity>>();
        for (VariableStore.GetVariablesRequest req : requests) {
            VariableStore.FlowNodeTree flowNodeTree = flowNodeTrees.get(req.getProcessInstanceId());
            VariableStore.VariableMap resultingVariableMap = new VariableStore.VariableMap();
            this.accumulateVariables(resultingVariableMap, variableMaps, flowNodeTree, req.getFlowNodeInstanceId());
            response.put(req.getTaskId(), resultingVariableMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> (VariableEntity)e.getValue()).collect(Collectors.toList()));
        }
        return response;
    }

    @NotNull
    private Collector<Map.Entry<String, VariableEntity>, ArrayList<VariableDTO>, ArrayList<VariableDTO>> getVariableDTOListCollector() {
        return Collector.of(ArrayList::new, (list, entry) -> list.add(VariableDTO.createFrom((VariableEntity)entry.getValue())), (list1, list2) -> {
            list1.addAll(list2);
            return list1;
        }, new Collector.Characteristics[0]);
    }

    private void accumulateVariables(VariableStore.VariableMap resultingVariableMap, Map<String, VariableStore.VariableMap> variableMaps, VariableStore.FlowNodeTree flowNodeTree, String flowNodeInstanceId) {
        String parentFlowNodeId;
        VariableStore.VariableMap m = variableMaps.get(flowNodeInstanceId);
        if (m != null) {
            resultingVariableMap.putAll(m);
        }
        String string = parentFlowNodeId = flowNodeTree != null ? flowNodeTree.getParent(flowNodeInstanceId) : null;
        if (parentFlowNodeId != null && !parentFlowNodeId.equals(ABSENT_PARENT_ID)) {
            this.accumulateVariables(resultingVariableMap, variableMaps, flowNodeTree, parentFlowNodeId);
        }
    }

    private Map<String, VariableStore.VariableMap> buildVariableMaps(List<String> flowNodeInstanceIds, List<String> varNames, Set<String> fieldNames) {
        List variables = this.variableStore.getVariablesByFlowNodeInstanceIds(flowNodeInstanceIds, varNames, fieldNames);
        return variables.stream().collect(Collectors.groupingBy(v -> String.valueOf(v.getScopeKey()), this.getVariableMapCollector()));
    }

    @NotNull
    private Collector<VariableEntity, VariableStore.VariableMap, VariableStore.VariableMap> getVariableMapCollector() {
        return Collector.of(VariableStore.VariableMap::new, (map, var) -> map.put((Object)var.getName(), var), (map1, map2) -> {
            map1.putAll(map2);
            return map1;
        }, new Collector.Characteristics[0]);
    }

    private Map<String, VariableStore.FlowNodeTree> buildFlowNodeTrees(List<VariableStore.GetVariablesRequest> requests) {
        List<String> processInstanceIds = requests.stream().map(VariableStore.GetVariablesRequest::getProcessInstanceId).filter(Objects::nonNull).distinct().toList();
        List flowNodeInstances = this.variableStore.getFlowNodeInstances(processInstanceIds.stream().map(Long::parseLong).toList());
        HashMap<String, VariableStore.FlowNodeTree> flowNodeTrees = new HashMap<String, VariableStore.FlowNodeTree>();
        for (FlowNodeInstanceEntity flowNodeInstance : flowNodeInstances) {
            this.getFlowNodeTree(flowNodeTrees, String.valueOf(flowNodeInstance.getProcessInstanceKey())).setParent(flowNodeInstance.getId(), String.valueOf(this.getScopeKey(flowNodeInstance)));
        }
        flowNodeTrees.keySet().forEach(id -> this.getFlowNodeTree((Map<String, VariableStore.FlowNodeTree>)flowNodeTrees, (String)id).setParent(id, ABSENT_PARENT_ID));
        return flowNodeTrees;
    }

    private Long getScopeKey(FlowNodeInstanceEntity flowNodeInstance) {
        return Optional.ofNullable(flowNodeInstance.getScopeKey()).map(this::getScopeKeyIfPresent).orElseGet(() -> this.getScopeKeyFromTreePathIfPresent(flowNodeInstance));
    }

    private Long getScopeKeyIfPresent(Long scopeKey) {
        return !ABSENT_PARENT_ID.equals(String.valueOf(scopeKey)) ? scopeKey : null;
    }

    private Long getScopeKeyFromTreePathIfPresent(FlowNodeInstanceEntity flowNodeInstance) {
        return Optional.ofNullable(flowNodeInstance.getTreePath()).map(this::splitTreePath).map(v -> this.getParentScopeKey(flowNodeInstance, (List<Long>)v)).orElse(flowNodeInstance.getProcessInstanceKey());
    }

    private List<Long> splitTreePath(String treePath) {
        return Arrays.stream(treePath.split("/")).map(Long::valueOf).collect(Collectors.toList());
    }

    private Long getParentScopeKey(FlowNodeInstanceEntity flowNodeInstance, List<Long> treePath) {
        if (!treePath.isEmpty() && treePath.getLast().equals(flowNodeInstance.getKey())) {
            treePath.removeLast();
        }
        return !treePath.isEmpty() ? treePath.getLast() : null;
    }

    private VariableStore.FlowNodeTree getFlowNodeTree(Map<String, VariableStore.FlowNodeTree> flowNodeTrees, String processInstanceId) {
        return flowNodeTrees.computeIfAbsent(processInstanceId, pi -> new VariableStore.FlowNodeTree());
    }

    public List<VariableSearchResponse> getVariableSearchResponses(String taskId, Set<String> variableNames) {
        TaskEntity task = this.taskStore.getTask(taskId);
        List<VariableStore.GetVariablesRequest> requests = Collections.singletonList(VariableStore.GetVariablesRequest.createFrom((TaskEntity)task).setVarNames(new ArrayList<String>(variableNames)).setFieldNames(Collections.emptySet()));
        ArrayList<VariableSearchResponse> vars = new ArrayList<VariableSearchResponse>();
        switch (task.getState()) {
            case CREATED: {
                HashMap<String, VariableEntity> nameToOriginalVariables = new HashMap<String, VariableEntity>();
                this.getRuntimeVariablesDTOPerTaskId(requests).forEach(originalVar -> nameToOriginalVariables.put(originalVar.getName(), (VariableEntity)originalVar));
                HashMap nameToDraftVariable = new HashMap();
                this.draftVariableStore.getVariablesByTaskIdAndVariableNames(taskId, new ArrayList<String>(variableNames)).forEach(draftVar -> nameToDraftVariable.put(draftVar.getName(), draftVar));
                nameToOriginalVariables.forEach((name, originalVar) -> {
                    if (nameToDraftVariable.containsKey(name)) {
                        vars.add(VariableSearchResponse.createFrom(originalVar, (DraftTaskVariableEntity)nameToDraftVariable.get(name)));
                    } else {
                        vars.add(VariableSearchResponse.createFrom(originalVar));
                    }
                });
                CollectionUtils.removeAll(nameToDraftVariable.keySet(), nameToOriginalVariables.keySet()).forEach(draftVariableName -> vars.add(VariableSearchResponse.createFrom((DraftTaskVariableEntity)nameToDraftVariable.get(draftVariableName))));
                break;
            }
            case COMPLETED: {
                Map variablesByTaskIds = this.variableStore.getTaskVariablesPerTaskId(requests);
                if (variablesByTaskIds.size() <= 0) break;
                vars.addAll(((List)variablesByTaskIds.values().iterator().next()).stream().map(VariableSearchResponse::createFrom).toList());
                break;
            }
        }
        return vars.stream().sorted(Comparator.comparing(VariableSearchResponse::getName)).toList();
    }

    public List<VariableDTO> getVariables(String taskId, List<String> variableNames, Set<String> fieldNames) {
        TaskEntity task = this.taskStore.getTask(taskId);
        List<VariableStore.GetVariablesRequest> requests = Collections.singletonList(VariableStore.GetVariablesRequest.createFrom((TaskEntity)task).setVarNames(variableNames).setFieldNames(fieldNames));
        ArrayList<VariableDTO> vars = new ArrayList<VariableDTO>();
        switch (task.getState()) {
            case CREATED: {
                vars.addAll(VariableDTO.createFrom(this.getRuntimeVariablesDTOPerTaskId(requests)));
                break;
            }
            case COMPLETED: {
                Map variablesByTaskIds = this.variableStore.getTaskVariablesPerTaskId(requests);
                if (variablesByTaskIds.size() <= 0) break;
                vars.addAll(((List)variablesByTaskIds.values().iterator().next()).stream().map(VariableDTO::createFrom).toList());
                break;
            }
        }
        vars.sort(Comparator.comparing(VariableDTO::getName));
        return vars;
    }

    public List<List<VariableDTO>> getVariables(List<VariableStore.GetVariablesRequest> requests) {
        Map<String, List<VariableDTO>> variablesPerTaskId = this.getVariablesPerTaskId(requests);
        ArrayList<List<VariableDTO>> result = new ArrayList<List<VariableDTO>>();
        for (VariableStore.GetVariablesRequest req : requests) {
            result.add(variablesPerTaskId.getOrDefault(req.getTaskId(), Collections.emptyList()).stream().sorted(Comparator.comparing(VariableDTO::getName)).toList());
        }
        return result;
    }

    public Map<String, List<VariableDTO>> getVariablesPerTaskId(List<VariableStore.GetVariablesRequest> requests) {
        HashMap<String, List<VariableDTO>> result = new HashMap<String, List<VariableDTO>>();
        Map<TaskState, List<VariableStore.GetVariablesRequest>> groupByStates = requests.stream().collect(Collectors.groupingBy(VariableStore.GetVariablesRequest::getState));
        if (groupByStates.containsKey(TaskState.CREATED)) {
            result.putAll(this.getRuntimeVariablesPerTaskId(groupByStates.get(TaskState.CREATED)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> VariableDTO.createFrom((List)e.getValue()))));
        }
        if (groupByStates.containsKey(TaskState.COMPLETED)) {
            result.putAll(this.variableStore.getTaskVariablesPerTaskId(groupByStates.get(TaskState.COMPLETED)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> VariableDTO.createFromTaskVariables((List)e.getValue()))));
        }
        return result;
    }

    public VariableDTO getVariable(String variableId, Set<String> fieldNames) {
        try {
            VariableEntity runtimeVariable = this.variableStore.getRuntimeVariable(variableId, fieldNames);
            return VariableDTO.createFrom(runtimeVariable);
        }
        catch (NotFoundException ex) {
            try {
                SnapshotTaskVariableEntity taskVariable = this.variableStore.getTaskVariable(variableId, fieldNames);
                return VariableDTO.createFrom(taskVariable);
            }
            catch (NotFoundException ex2) {
                throw new NotFoundApiException(String.format("Variable with id %s not found.", variableId));
            }
        }
    }

    public VariableResponse getVariableResponse(String variableId) {
        try {
            VariableEntity runtimeVariable = this.variableStore.getRuntimeVariable(variableId, Collections.emptySet());
            VariableResponse variableResponse = VariableResponse.createFrom(runtimeVariable);
            this.draftVariableStore.getById(variableId).ifPresent(variableResponse::addDraft);
            return variableResponse;
        }
        catch (NotFoundException ex) {
            return this.draftVariableStore.getById(variableId).map(VariableResponse::createFrom).orElseGet(() -> {
                try {
                    SnapshotTaskVariableEntity taskVariable = this.variableStore.getTaskVariable(variableId, Collections.emptySet());
                    return VariableResponse.createFrom(taskVariable);
                }
                catch (NotFoundException ex2) {
                    throw new NotFoundApiException(String.format("Variable with id %s not found.", variableId));
                }
            });
        }
    }

    public static String getDraftVariableId(String idPrefix, String name) {
        return String.format("%s-%s", idPrefix, name);
    }

    public static String getSnapshotVariableId(String idPrefix, String name) {
        return String.format("%s-%s", idPrefix, name);
    }

    private static DraftTaskVariableEntity createDraftVariableFrom(TaskEntity taskEntity, String name, String value, int variableSizeThreshold) {
        return VariableService.completeVariableSetup(new DraftTaskVariableEntity().setId(VariableService.getDraftVariableId(String.valueOf(taskEntity.getKey()), name)), taskEntity, name, value, variableSizeThreshold);
    }

    private static DraftTaskVariableEntity createDraftVariableFrom(String draftVariableId, TaskEntity taskEntity, String name, String value, int variableSizeThreshold) {
        return VariableService.completeVariableSetup(new DraftTaskVariableEntity().setId(draftVariableId), taskEntity, name, value, variableSizeThreshold);
    }

    private static DraftTaskVariableEntity completeVariableSetup(DraftTaskVariableEntity entity, TaskEntity taskEntity, String name, String value, int variableSizeThreshold) {
        entity.setTaskId(String.valueOf(taskEntity.getKey())).setName(name).setTenantId(taskEntity.getTenantId());
        if (value.length() > variableSizeThreshold) {
            entity.setValue(value.substring(0, variableSizeThreshold));
            entity.setIsPreview(true);
        } else {
            entity.setValue(value);
        }
        entity.setFullValue(value);
        return entity;
    }

    public static SnapshotTaskVariableEntity createSnapshotVariableFrom(String tenantId, String taskId, Long processInstanceKey, String name, String value, int variableSizeThreshold) {
        SnapshotTaskVariableEntity entity = new SnapshotTaskVariableEntity().setId(VariableService.getSnapshotVariableId(taskId, name)).setTaskId(taskId).setProcessInstanceKey(processInstanceKey).setName(name);
        if (value.length() > variableSizeThreshold) {
            entity.setValue(value.substring(0, variableSizeThreshold));
            entity.setIsPreview(true);
        } else {
            entity.setValue(value);
        }
        entity.setFullValue(value);
        entity.setTenantId(tenantId);
        return entity;
    }

    public static SnapshotTaskVariableEntity createSnapshotVariableFrom(String taskId, VariableEntity variableEntity) {
        return new SnapshotTaskVariableEntity().setId(VariableService.getSnapshotVariableId(taskId, variableEntity.getName())).setTaskId(taskId).setProcessInstanceKey(variableEntity.getProcessInstanceKey()).setName(variableEntity.getName()).setValue(variableEntity.getValue()).setIsPreview(variableEntity.getIsPreview()).setFullValue(variableEntity.getIsPreview() ? variableEntity.getFullValue() : variableEntity.getValue()).setTenantId(variableEntity.getTenantId());
    }

    public static SnapshotTaskVariableEntity createSnapshotVariableFrom(String taskId, Long processInstanceKey, DraftTaskVariableEntity draftTaskVariableEntity) {
        return new SnapshotTaskVariableEntity().setId(VariableService.getSnapshotVariableId(taskId, draftTaskVariableEntity.getName())).setTaskId(taskId).setProcessInstanceKey(processInstanceKey).setName(draftTaskVariableEntity.getName()).setValue(draftTaskVariableEntity.getValue()).setIsPreview(draftTaskVariableEntity.getIsPreview()).setFullValue(draftTaskVariableEntity.getFullValue()).setTenantId(draftTaskVariableEntity.getTenantId());
    }
}

