/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.service;

import io.camunda.client.CamundaClient;
import io.camunda.client.api.command.ClientException;
import io.camunda.client.api.command.ClientStatusException;
import io.camunda.client.api.command.CreateProcessInstanceCommandStep1;
import io.camunda.client.api.command.DeployResourceCommandStep1;
import io.camunda.client.api.response.ProcessInstanceEvent;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.util.ConditionalOnTasklistCompatibility;
import io.camunda.tasklist.webapp.permission.TasklistPermissionServices;
import io.camunda.tasklist.webapp.rest.exception.ForbiddenActionException;
import io.camunda.tasklist.webapp.rest.exception.NotFoundApiException;
import io.camunda.tasklist.webapp.tenant.TenantService;
import io.camunda.tasklist.webapp.util.ErrorHandlingUtils;
import io.camunda.tasklist.zeebe.TasklistServicesAdapter;
import io.camunda.webapps.schema.entities.usertask.TaskEntity;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.grpc.Status;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnTasklistCompatibility(enabled="true")
public class CamundaClientBasedAdapter
implements TasklistServicesAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamundaClientBasedAdapter.class);
    private final CamundaClient camundaClient;
    private final TasklistPermissionServices permissionServices;
    private final TenantService tenantService;

    public CamundaClientBasedAdapter(@Qualifier(value="tasklistCamundaClient") CamundaClient camundaClient, TasklistPermissionServices permissionServices, TenantService tenantService) {
        this.camundaClient = camundaClient;
        this.permissionServices = permissionServices;
        this.tenantService = tenantService;
    }

    public ProcessInstanceCreationRecord createProcessInstance(String bpmnProcessId, Map<String, Object> variables, String tenantId) {
        if (this.isNotAuthorizedToCreateProcessInstance(bpmnProcessId)) {
            throw new ForbiddenActionException("Not allowed to create process of process definition %s.".formatted(bpmnProcessId));
        }
        return this.doCreateProcessInstance(bpmnProcessId, variables, tenantId);
    }

    public ProcessInstanceCreationRecord createProcessInstanceWithoutAuthentication(String bpmnProcessId, Map<String, Object> variables, String tenantId) {
        return this.doCreateProcessInstance(bpmnProcessId, variables, tenantId);
    }

    public void assignUserTask(TaskEntity task, String assignee) {
        if (this.isNotAuthorizedToAssignUserTask(task)) {
            throw new ForbiddenActionException("Not allowed to assign user task %s.".formatted(task.getKey()));
        }
        if (!this.isJobBasedUserTask(task)) {
            try {
                this.camundaClient.newAssignUserTaskCommand(task.getKey()).assignee(assignee).send().join();
            }
            catch (ClientException exception) {
                throw new TasklistRuntimeException(ErrorHandlingUtils.getErrorMessageFromClientException(exception));
            }
        }
    }

    public void unassignUserTask(TaskEntity task) {
        if (this.isNotAuthorizedToAssignUserTask(task)) {
            throw new ForbiddenActionException("Not allowed to unassign user task %s.".formatted(task.getKey()));
        }
        if (!this.isJobBasedUserTask(task)) {
            try {
                this.camundaClient.newUnassignUserTaskCommand(task.getKey()).send().join();
            }
            catch (ClientException exception) {
                throw new TasklistRuntimeException(ErrorHandlingUtils.getErrorMessageFromClientException(exception));
            }
        }
    }

    public void completeUserTask(TaskEntity task, Map<String, Object> variables) {
        if (this.isNotAuthorizedToAssignUserTask(task)) {
            throw new ForbiddenActionException("Not allowed to complete user task %s.".formatted(task.getKey()));
        }
        try {
            if (this.isJobBasedUserTask(task)) {
                this.camundaClient.newCompleteCommand(task.getKey()).variables(variables).send().join();
            } else {
                this.camundaClient.newCompleteUserTaskCommand(task.getKey()).variables(variables).send().join();
            }
        }
        catch (ClientException exception) {
            throw new TasklistRuntimeException(ErrorHandlingUtils.getErrorMessageFromClientException(exception));
        }
    }

    public void deployResourceWithoutAuthentication(String classpathResource, String tenantId) {
        DeployResourceCommandStep1.DeployResourceCommandStep2 deployResourceCommandStep2 = this.camundaClient.newDeployResourceCommand().addResourceFromClasspath(classpathResource);
        if (this.tenantService.isMultiTenancyEnabled()) {
            deployResourceCommandStep2.tenantId(tenantId);
        }
        deployResourceCommandStep2.send();
    }

    private ProcessInstanceCreationRecord doCreateProcessInstance(String bpmnProcessId, Map<String, Object> variables, String tenantId) {
        CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 createProcessInstanceCommandStep3 = this.camundaClient.newCreateInstanceCommand().bpmnProcessId(bpmnProcessId).latestVersion();
        if (this.tenantService.isMultiTenancyEnabled()) {
            createProcessInstanceCommandStep3.tenantId(tenantId);
        }
        if (variables != null && !variables.isEmpty()) {
            createProcessInstanceCommandStep3.variables(variables);
        }
        ProcessInstanceEvent processInstanceEvent = null;
        try {
            processInstanceEvent = (ProcessInstanceEvent)createProcessInstanceCommandStep3.send().join();
            LOGGER.debug("Process instance created for process [{}]", (Object)bpmnProcessId);
        }
        catch (ClientStatusException ex) {
            if (Status.Code.NOT_FOUND.equals((Object)ex.getStatusCode())) {
                throw new NotFoundApiException(String.format("No process definition found with processDefinitionKey: '%s'", bpmnProcessId), ex);
            }
            throw new TasklistRuntimeException(ex.getMessage(), (Throwable)ex);
        }
        catch (ClientException ex) {
            throw new TasklistRuntimeException(ex.getMessage(), (Throwable)ex);
        }
        return new ProcessInstanceCreationRecord().setProcessInstanceKey(processInstanceEvent.getProcessInstanceKey());
    }

    private boolean isNotAuthorizedToAssignUserTask(TaskEntity task) {
        return !this.permissionServices.hasPermissionToUpdateUserTask(task);
    }

    private boolean isNotAuthorizedToCreateProcessInstance(String bpmnProcessId) {
        return !this.permissionServices.hasPermissionToCreateProcessInstance(bpmnProcessId);
    }
}

