/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.rest;

import com.google.common.base.Charsets;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CustomCssRestService {
    public static final String TASKLIST_CUSTOM_CSS = "/tasklist/custom.css";
    public static final String PATH_LOCATION = "custom.css";
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomCssRestService.class);
    private String customCssContent;

    @PostConstruct
    public void init() {
        try {
            Resource resource = this.loadResource(PATH_LOCATION);
            this.customCssContent = new String(resource.getContentAsString(Charsets.UTF_8));
        }
        catch (IOException e) {
            LOGGER.error("Error when reading custom css file {}", (Object)PATH_LOCATION, (Object)e);
            this.customCssContent = "";
        }
    }

    @Hidden
    @GetMapping(path={"/tasklist/custom.css"}, produces={"text/css"})
    public String getClientConfig() {
        return this.customCssContent;
    }

    public Resource loadResource(String path) {
        return new ClassPathResource(path);
    }

    public String getCustomCssContent() {
        return this.customCssContent;
    }
}

