/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.permission;

import io.camunda.security.auth.Authorization;
import io.camunda.security.auth.CamundaAuthentication;
import io.camunda.security.auth.CamundaAuthenticationProvider;
import io.camunda.security.reader.ResourceAccess;
import io.camunda.security.reader.ResourceAccessProvider;
import io.camunda.tasklist.util.LazySupplier;
import io.camunda.webapps.schema.entities.usertask.TaskEntity;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class TasklistPermissionServices {
    public static final String WILDCARD_RESOURCE = "*";
    private static final Authorization<?> READ_PROC_DEF_AUTH_CHECK = Authorization.of(a -> a.processDefinition().readProcessDefinition());
    private static final Authorization<?> CREATE_PROC_INST_AUTH_CHECK = Authorization.of(a -> a.processDefinition().createProcessInstance());
    private static final Authorization<?> UPDATE_USER_TASK_AUTH_CHECK = Authorization.of(a -> a.processDefinition().updateUserTask());
    private static final Authorization<?> READ_USER_TASK_AUTH_CHECK = Authorization.of(a -> a.processDefinition().readUserTask());
    private static final Authorization<?> READ_PROCESS_INSTANCE_AUTH_CHECK = Authorization.of(a -> a.processDefinition().readProcessInstance());
    private final CamundaAuthenticationProvider authenticationProvider;
    private final ResourceAccessProvider resourceAccessProvider;

    public TasklistPermissionServices(CamundaAuthenticationProvider authenticationProvider, ResourceAccessProvider resourceAccessProvider) {
        this.authenticationProvider = authenticationProvider;
        this.resourceAccessProvider = resourceAccessProvider;
    }

    public boolean hasPermissionToCreateProcessInstance(String bpmnProcessId) {
        return this.isAuthorizedForResource(bpmnProcessId, CREATE_PROC_INST_AUTH_CHECK);
    }

    public boolean hasPermissionToReadProcessDefinition(String bpmnProcessId) {
        return this.isAuthorizedForResource(bpmnProcessId, READ_PROC_DEF_AUTH_CHECK);
    }

    public boolean hasPermissionToUpdateUserTask(TaskEntity task) {
        return this.isAuthorizedForResource(task.getBpmnProcessId(), UPDATE_USER_TASK_AUTH_CHECK);
    }

    public boolean hasWildcardPermissionToReadUserTask() {
        return this.isAuthorizedForResource(WILDCARD_RESOURCE, READ_USER_TASK_AUTH_CHECK);
    }

    public boolean hasWildcardPermissionToReadProcessInstance() {
        return this.isAuthorizedForResource(WILDCARD_RESOURCE, READ_PROCESS_INSTANCE_AUTH_CHECK);
    }

    public List<String> getProcessDefinitionsWithCreateProcessInstancePermission() {
        LazySupplier authenticationSupplier = LazySupplier.of(() -> ((CamundaAuthenticationProvider)this.authenticationProvider).getCamundaAuthentication());
        ResourceAccess resourceAccess = this.resourceAccessProvider.resolveResourceAccess((CamundaAuthentication)authenticationSupplier.get(), CREATE_PROC_INST_AUTH_CHECK);
        return resourceAccess.allowed() ? resourceAccess.authorization().resourceIds() : List.of();
    }

    public List<String> getProcessDefinitionsWithReadUserTaskPermission() {
        LazySupplier authenticationSupplier = LazySupplier.of(() -> ((CamundaAuthenticationProvider)this.authenticationProvider).getCamundaAuthentication());
        ResourceAccess resourceAccess = this.resourceAccessProvider.resolveResourceAccess((CamundaAuthentication)authenticationSupplier.get(), READ_USER_TASK_AUTH_CHECK);
        return resourceAccess.allowed() ? resourceAccess.authorization().resourceIds() : List.of();
    }

    private boolean isAuthorizedForResource(String resourceId, Authorization<?> authorization) {
        LazySupplier authenticationSupplier = LazySupplier.of(() -> ((CamundaAuthenticationProvider)this.authenticationProvider).getCamundaAuthentication());
        return this.resourceAccessProvider.hasResourceAccessByResourceId((CamundaAuthentication)authenticationSupplier.get(), authorization, resourceId).allowed();
    }
}

