/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.es.tenant;

import io.camunda.security.reader.TenantAccess;
import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.tenant.TenantCheckApplier;
import io.camunda.tasklist.util.OpenSearchUtil;
import io.camunda.tasklist.webapp.tenant.TenantService;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpenSearchCondition.class})
@Component
public class OpenSearchTenantCheckApplier
implements TenantCheckApplier<SearchRequest.Builder> {
    @Autowired
    private TenantService tenantService;

    public void apply(SearchRequest.Builder searchRequest) {
        TenantAccess tenantAccess = this.tenantService.getAuthenticatedTenants();
        this.applyTenantCheckOnQuery(searchRequest, tenantAccess, tenantAccess.tenantIds());
    }

    public void apply(SearchRequest.Builder searchRequest, Collection<String> tenantIds) {
        TenantAccess tenantAccess = this.tenantService.getAuthenticatedTenants();
        Set authorizedTenantIds = Optional.ofNullable(tenantAccess.tenantIds()).map(Set::copyOf).orElseGet(HashSet::new);
        Set<String> searchByTenantIds = tenantIds.stream().filter(authorizedTenantIds::contains).collect(Collectors.toSet());
        this.applyTenantCheckOnQuery(searchRequest, tenantAccess, searchByTenantIds);
    }

    private void applyTenantCheckOnQuery(SearchRequest.Builder searchRequest, TenantAccess tenantAccess, Collection<String> searchByTenantIds) {
        Query actualQuery = this.getQueryFromSearchRequestBuilder(searchRequest);
        if (tenantAccess.wildcard()) {
            searchRequest.query(actualQuery);
        } else if (tenantAccess.denied() || CollectionUtils.isEmpty(searchByTenantIds)) {
            searchRequest.query(OpenSearchUtil.createMatchNoneQuery());
        } else if (tenantAccess.allowed()) {
            Query tenantTermsQuery = this.getTenantTermsQuery(searchByTenantIds);
            Query finalQuery = OpenSearchUtil.joinWithAnd((Query[])new Query[]{tenantTermsQuery, actualQuery});
            searchRequest.query(finalQuery);
        } else {
            String message = String.format("Unexpected tenant access type %s", tenantAccess);
            throw new TasklistRuntimeException(message);
        }
    }

    private Query getTenantTermsQuery(Collection<String> searchByTenantIds) {
        return (Query)new Query.Builder().terms(terms -> terms.field("tenantId").terms(values -> values.value(searchByTenantIds.stream().map(FieldValue::of).collect(Collectors.toList())))).build();
    }

    private Query getQueryFromSearchRequestBuilder(SearchRequest.Builder searchRequest) {
        try {
            Field privateField = SearchRequest.Builder.class.getDeclaredField("query");
            privateField.setAccessible(true);
            return (Query)privateField.get(searchRequest);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

