/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.es.tenant;

import io.camunda.security.reader.TenantAccess;
import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.tenant.TenantCheckApplier;
import io.camunda.tasklist.util.ElasticsearchUtil;
import io.camunda.tasklist.webapp.tenant.TenantService;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticSearchCondition.class})
@Component
public class ElasticsearchTenantCheckApplier
implements TenantCheckApplier<SearchRequest> {
    @Autowired
    private TenantService tenantService;

    public void apply(SearchRequest searchRequest) {
        TenantAccess tenantAccess = this.tenantService.getAuthenticatedTenants();
        ElasticsearchTenantCheckApplier.applyTenantCheckOnQuery(searchRequest, tenantAccess, tenantAccess.tenantIds());
    }

    public void apply(SearchRequest searchRequest, Collection<String> tenantIds) {
        TenantAccess tenantAccess = this.tenantService.getAuthenticatedTenants();
        Set authorizedTenantIds = Optional.ofNullable(tenantAccess.tenantIds()).map(Set::copyOf).orElseGet(HashSet::new);
        Set<String> searchByTenantIds = tenantIds.stream().filter(authorizedTenantIds::contains).collect(Collectors.toSet());
        ElasticsearchTenantCheckApplier.applyTenantCheckOnQuery(searchRequest, tenantAccess, searchByTenantIds);
    }

    private static void applyTenantCheckOnQuery(SearchRequest searchRequest, TenantAccess tenantAccess, Collection<String> searchByTenantIds) {
        QueryBuilder actualQuery = searchRequest.source().query();
        if (tenantAccess.wildcard()) {
            searchRequest.source().query(actualQuery);
        } else if (tenantAccess.denied() || CollectionUtils.isEmpty(searchByTenantIds)) {
            searchRequest.source().query((QueryBuilder)ElasticsearchUtil.createMatchNoneQuery());
        } else if (tenantAccess.allowed()) {
            TermsQueryBuilder tenantTermsQuery = QueryBuilders.termsQuery((String)"tenantId", searchByTenantIds);
            QueryBuilder finalQuery = ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{tenantTermsQuery, actualQuery});
            searchRequest.source().query(finalQuery);
        } else {
            String message = String.format("Unexpected tenant access type %s", tenantAccess);
            throw new TasklistRuntimeException(message);
        }
    }
}

