/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.es.cache;

import io.camunda.spring.utils.ConditionalOnRdbmsDisabled;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.store.ProcessStore;
import io.camunda.tasklist.webapp.es.cache.ProcessCacheEntity;
import io.camunda.webapps.schema.entities.ProcessEntity;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnRdbmsDisabled
public class ProcessCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessCache.class);
    private static final int CACHE_MAX_SIZE = 100;
    private final Map<String, ProcessCacheEntity> cache = new ConcurrentHashMap<String, ProcessCacheEntity>();
    @Autowired
    private ProcessStore processStore;

    private ProcessCacheEntity getProcessCacheEntity(String processId) {
        Optional<ProcessEntity> processMaybe;
        if (this.cache.get(processId) == null && (processMaybe = this.readProcessByKey(processId)).isPresent()) {
            ProcessEntity process = processMaybe.get();
            this.putToCache(processId, process);
        }
        return this.cache.get(processId);
    }

    public String getProcessName(String processId) {
        ProcessCacheEntity cachedProcessData = this.getProcessCacheEntity(processId);
        if (cachedProcessData != null) {
            return cachedProcessData.getName();
        }
        return null;
    }

    public String getTaskName(String processId, String flowNodeBpmnId) {
        ProcessCacheEntity cachedProcessData = this.getProcessCacheEntity(processId);
        if (cachedProcessData != null) {
            return cachedProcessData.getFlowNodeNames().get(flowNodeBpmnId);
        }
        return null;
    }

    private Optional<ProcessEntity> readProcessByKey(String processId) {
        try {
            return Optional.of(this.processStore.getProcess(processId));
        }
        catch (TasklistRuntimeException ex) {
            return Optional.empty();
        }
    }

    public void putToCache(String processId, ProcessEntity process) {
        Iterator<String> iterator;
        if (this.cache.size() >= 100 && (iterator = this.cache.keySet().iterator()).hasNext()) {
            iterator.next();
            iterator.remove();
        }
        this.cache.put(processId, ProcessCacheEntity.createFrom(process));
    }

    public void clearCache() {
        this.cache.clear();
    }
}

