/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.dto;

import io.camunda.tasklist.queries.DateFilter;
import io.camunda.tasklist.queries.RangeValueFilter;
import io.camunda.tasklist.queries.TaskByCandidateUserOrGroup;
import io.camunda.tasklist.queries.TaskByVariables;
import io.camunda.tasklist.queries.TaskOrderBy;
import io.camunda.tasklist.queries.TaskQuery;
import io.camunda.webapps.schema.entities.usertask.TaskEntity;
import io.camunda.webapps.schema.entities.usertask.TaskState;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class TaskQueryDTO {
    public static final int DEFAULT_PAGE_SIZE = 50;
    private TaskState state;
    private Boolean assigned;
    private String assignee;
    private String[] assignees;
    private String taskDefinitionId;
    private String candidateGroup;
    private String[] candidateGroups;
    private String candidateUser;
    private String[] candidateUsers;
    private String processDefinitionId;
    private String processInstanceId;
    private TaskByVariables[] taskVariables;
    private String[] tenantIds;
    private int pageSize = 50;
    private String[] searchAfter;
    private String[] searchAfterOrEqual;
    private String[] searchBefore;
    private String[] searchBeforeOrEqual;
    private DateFilter followUpDate;
    private DateFilter dueDate;
    private TaskOrderBy[] sort;
    private TaskByCandidateUserOrGroup taskByCandidateUserOrGroup;
    private TaskEntity.TaskImplementation implementation;
    private RangeValueFilter priority;

    public TaskQueryDTO(TaskState state, Boolean assigned, String assignee, String taskDefinitionId, String candidateGroup, String candidateUser, String processDefinitionId, String processInstanceId, Integer pageSize, List<String> searchAfter, List<String> searchAfterOrEqual, List<String> searchBefore, List<String> searchBeforeOrEqual, DateFilter followUpDate, DateFilter dueDate, TaskOrderBy[] sort, TaskEntity.TaskImplementation implementation) {
        this.state = state;
        this.assigned = assigned;
        this.assignee = assignee;
        this.taskDefinitionId = taskDefinitionId;
        this.candidateGroup = candidateGroup;
        this.candidateUser = candidateUser;
        this.processDefinitionId = processDefinitionId;
        this.processInstanceId = processInstanceId;
        this.pageSize = pageSize != null ? pageSize : 50;
        this.searchAfter = searchAfter != null ? searchAfter.toArray(new String[0]) : null;
        this.searchAfterOrEqual = searchAfterOrEqual != null ? searchAfterOrEqual.toArray(new String[0]) : null;
        this.searchBefore = searchBefore != null ? searchBefore.toArray(new String[0]) : null;
        this.searchBeforeOrEqual = searchBeforeOrEqual != null ? searchBeforeOrEqual.toArray(new String[0]) : null;
        this.followUpDate = followUpDate;
        this.dueDate = dueDate;
        this.sort = sort;
        this.implementation = implementation;
        this.priority = this.priority;
    }

    public TaskQueryDTO() {
    }

    public TaskState getState() {
        return this.state;
    }

    public TaskQueryDTO setState(TaskState state) {
        this.state = state;
        return this;
    }

    public Boolean getAssigned() {
        return this.assigned;
    }

    public TaskQueryDTO setAssigned(Boolean assigned) {
        this.assigned = assigned;
        return this;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public TaskQueryDTO setAssignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    public TaskByVariables[] getTaskVariables() {
        return this.taskVariables;
    }

    public TaskQueryDTO setTaskVariables(TaskByVariables[] taskVariables) {
        this.taskVariables = taskVariables;
        return this;
    }

    public String[] getTenantIds() {
        return this.tenantIds;
    }

    public TaskQueryDTO setTenantIds(String[] tenantIds) {
        this.tenantIds = tenantIds;
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public TaskQueryDTO setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public String[] getSearchAfter() {
        return this.searchAfter;
    }

    public TaskQueryDTO setSearchAfter(String[] searchAfter) {
        this.searchAfter = searchAfter;
        return this;
    }

    public String[] getSearchAfterOrEqual() {
        return this.searchAfterOrEqual;
    }

    public TaskQueryDTO setSearchAfterOrEqual(String[] searchAfterOrEqual) {
        this.searchAfterOrEqual = searchAfterOrEqual;
        return this;
    }

    public String[] getSearchBefore() {
        return this.searchBefore;
    }

    public TaskQueryDTO setSearchBefore(String[] searchBefore) {
        this.searchBefore = searchBefore;
        return this;
    }

    public String[] getSearchBeforeOrEqual() {
        return this.searchBeforeOrEqual;
    }

    public TaskQueryDTO setSearchBeforeOrEqual(String[] searchBeforeOrEqual) {
        this.searchBeforeOrEqual = searchBeforeOrEqual;
        return this;
    }

    public String getTaskDefinitionId() {
        return this.taskDefinitionId;
    }

    public TaskQueryDTO setTaskDefinitionId(String taskDefinitionId) {
        this.taskDefinitionId = taskDefinitionId;
        return this;
    }

    public String getCandidateGroup() {
        return this.candidateGroup;
    }

    public TaskQueryDTO setCandidateGroup(String candidateGroup) {
        this.candidateGroup = candidateGroup;
        return this;
    }

    public String getCandidateUser() {
        return this.candidateUser;
    }

    public TaskQueryDTO setCandidateUser(String candidateUser) {
        this.candidateUser = candidateUser;
        return this;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public TaskQueryDTO setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public TaskQueryDTO setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    public DateFilter getFollowUpDate() {
        return this.followUpDate;
    }

    public TaskQueryDTO setFollowUpDate(DateFilter followUpDate) {
        this.followUpDate = followUpDate;
        return this;
    }

    public DateFilter getDueDate() {
        return this.dueDate;
    }

    public TaskQueryDTO setDueDate(DateFilter dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    public TaskOrderBy[] getSort() {
        return this.sort;
    }

    public TaskQueryDTO setSort(TaskOrderBy[] sort) {
        this.sort = sort;
        return this;
    }

    public TaskByCandidateUserOrGroup getTaskByCandidateUserOrGroup() {
        return this.taskByCandidateUserOrGroup;
    }

    public TaskQueryDTO setTaskByCandidateUserOrGroup(TaskByCandidateUserOrGroup taskByCandidateUserOrGroup) {
        this.taskByCandidateUserOrGroup = taskByCandidateUserOrGroup;
        return this;
    }

    public TaskEntity.TaskImplementation getImplementation() {
        return this.implementation;
    }

    public TaskQueryDTO setImplementation(TaskEntity.TaskImplementation implementation) {
        this.implementation = implementation;
        return this;
    }

    public String[] getAssignees() {
        return this.assignees;
    }

    public TaskQueryDTO setAssignees(String[] assignees) {
        this.assignees = assignees;
        return this;
    }

    public String[] getCandidateGroups() {
        return this.candidateGroups;
    }

    public TaskQueryDTO setCandidateGroups(String[] candidateGroups) {
        this.candidateGroups = candidateGroups;
        return this;
    }

    public String[] getCandidateUsers() {
        return this.candidateUsers;
    }

    public TaskQueryDTO setCandidateUsers(String[] candidateUsers) {
        this.candidateUsers = candidateUsers;
        return this;
    }

    public RangeValueFilter getPriority() {
        return this.priority;
    }

    public TaskQueryDTO setPriority(RangeValueFilter priority) {
        this.priority = priority;
        return this;
    }

    public int hashCode() {
        int result = Objects.hash(this.state, this.assigned, this.assignee, this.taskDefinitionId, this.candidateGroup, this.candidateUser, this.processDefinitionId, this.processInstanceId, this.pageSize, this.followUpDate, this.dueDate, this.taskByCandidateUserOrGroup, this.implementation, this.priority);
        result = 31 * result + Arrays.hashCode(this.assignees);
        result = 31 * result + Arrays.hashCode(this.candidateGroups);
        result = 31 * result + Arrays.hashCode(this.candidateUsers);
        result = 31 * result + Arrays.hashCode(this.taskVariables);
        result = 31 * result + Arrays.hashCode(this.tenantIds);
        result = 31 * result + Arrays.hashCode(this.searchAfter);
        result = 31 * result + Arrays.hashCode(this.searchAfterOrEqual);
        result = 31 * result + Arrays.hashCode(this.searchBefore);
        result = 31 * result + Arrays.hashCode(this.searchBeforeOrEqual);
        result = 31 * result + Arrays.hashCode(this.sort);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskQueryDTO that = (TaskQueryDTO)o;
        return this.pageSize == that.pageSize && this.state == that.state && this.implementation == that.implementation && Objects.equals(this.assigned, that.assigned) && Objects.equals(this.assignee, that.assignee) && Arrays.equals(this.assignees, that.assignees) && Objects.equals(this.taskDefinitionId, that.taskDefinitionId) && Objects.equals(this.candidateGroup, that.candidateGroup) && Arrays.equals(this.candidateGroups, that.candidateGroups) && Objects.equals(this.candidateUser, that.candidateUser) && Arrays.equals(this.candidateUsers, that.candidateUsers) && Objects.equals(this.processDefinitionId, that.processDefinitionId) && Objects.equals(this.processInstanceId, that.processInstanceId) && Arrays.equals(this.taskVariables, that.taskVariables) && Arrays.equals(this.tenantIds, that.tenantIds) && Arrays.equals(this.searchAfter, that.searchAfter) && Arrays.equals(this.searchAfterOrEqual, that.searchAfterOrEqual) && Arrays.equals(this.searchBefore, that.searchBefore) && Arrays.equals(this.searchBeforeOrEqual, that.searchBeforeOrEqual) && Objects.equals(this.followUpDate, that.followUpDate) && Objects.equals(this.dueDate, that.dueDate) && Arrays.equals(this.sort, that.sort) && Objects.equals(this.taskByCandidateUserOrGroup, that.taskByCandidateUserOrGroup) && Objects.equals(this.priority, that.priority);
    }

    public String toString() {
        return "TaskQueryDTO{state=" + String.valueOf(this.state) + ", assigned=" + this.assigned + ", assignee='" + this.assignee + "', assignees=" + Arrays.toString(this.assignees) + ", taskDefinitionId='" + this.taskDefinitionId + "', candidateGroup='" + this.candidateGroup + "', candidateGroups=" + Arrays.toString(this.candidateGroups) + ", candidateUser='" + this.candidateUser + "', candidateUsers=" + Arrays.toString(this.candidateUsers) + ", processDefinitionId='" + this.processDefinitionId + "', processInstanceId='" + this.processInstanceId + "', taskVariables=" + Arrays.toString(this.taskVariables) + ", tenantIds=" + Arrays.toString(this.tenantIds) + ", pageSize=" + this.pageSize + ", searchAfter=" + Arrays.toString(this.searchAfter) + ", searchAfterOrEqual=" + Arrays.toString(this.searchAfterOrEqual) + ", searchBefore=" + Arrays.toString(this.searchBefore) + ", searchBeforeOrEqual=" + Arrays.toString(this.searchBeforeOrEqual) + ", followUpDate=" + String.valueOf(this.followUpDate) + ", dueDate=" + String.valueOf(this.dueDate) + ", sort=" + Arrays.toString(this.sort) + ", taskByCandidateUserOrGroup=" + String.valueOf(this.taskByCandidateUserOrGroup) + ", implementation=" + String.valueOf(this.implementation) + ", priority=" + String.valueOf(this.priority) + "}";
    }

    public TaskQuery toTaskQuery() {
        return new TaskQuery().setState(this.state).setAssigned(this.assigned).setAssignee(this.assignee).setAssignees(this.assignees).setTaskDefinitionId(this.taskDefinitionId).setCandidateGroup(this.candidateGroup).setCandidateGroups(this.candidateGroups).setCandidateUser(this.candidateUser).setCandidateUsers(this.candidateUsers).setTaskByCandidateUserOrGroups(this.taskByCandidateUserOrGroup).setProcessDefinitionId(this.processDefinitionId).setProcessInstanceId(this.processInstanceId).setPageSize(this.pageSize).setTaskVariables(this.taskVariables).setTenantIds(this.tenantIds).setSearchAfter(this.searchAfter).setSearchAfterOrEqual(this.searchAfterOrEqual).setSearchBefore(this.searchBefore).setSearchBefore(this.searchBefore).setSearchBeforeOrEqual(this.searchBeforeOrEqual).setFollowUpDate(this.followUpDate).setDueDate(this.dueDate).setSort(this.sort).setImplementation(this.implementation).setPriority(this.priority);
    }
}

