/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.api.rest.v1.controllers.internal;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import io.camunda.search.connect.es.ElasticsearchConnector;
import io.camunda.search.schema.SchemaManager;
import io.camunda.search.schema.SearchEngineClient;
import io.camunda.search.schema.config.SearchEngineConfiguration;
import io.camunda.search.schema.elasticsearch.ElasticsearchEngineClient;
import io.camunda.tasklist.webapp.es.cache.ProcessCache;
import io.camunda.webapps.schema.descriptors.AbstractIndexDescriptor;
import io.camunda.webapps.schema.descriptors.IndexDescriptors;
import io.camunda.webapps.schema.descriptors.index.TasklistMetricIndex;
import io.camunda.webapps.schema.descriptors.template.DraftTaskVariableTemplate;
import io.camunda.webapps.schema.descriptors.template.FlowNodeInstanceTemplate;
import io.camunda.webapps.schema.descriptors.template.ListViewTemplate;
import io.camunda.webapps.schema.descriptors.template.SnapshotTaskVariableTemplate;
import io.camunda.webapps.schema.descriptors.template.TaskTemplate;
import io.camunda.webapps.schema.descriptors.template.UsageMetricTUTemplate;
import io.camunda.webapps.schema.descriptors.template.VariableTemplate;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import java.util.function.BiFunction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Profile(value={"e2e-test"})
@Tag(name="Util", description="This API it's just for internal use as dev utilities.")
@RestController
@RequestMapping(value={"/v1/external/devUtil"}, produces={"application/json"})
public class DevUtilExternalController {
    @Autowired
    private ProcessCache processCache;
    @Autowired
    private SearchEngineConfiguration configuration;

    @Operation(summary="Get details about the current user.", responses={@ApiResponse(description="On success returned", responseCode="200", useReturnTypeSchema=true)})
    @PostMapping(value={"recreateData"})
    public ResponseEntity<?> recreateData() throws IOException {
        ElasticsearchConnector connector = new ElasticsearchConnector(this.configuration.connect());
        IndexDescriptors indexDescriptors = new IndexDescriptors(this.configuration.connect().getIndexPrefix(), true);
        List<String> indicesToDelete = List.of(this.getIndexFullQualifiedName(DraftTaskVariableTemplate::new), this.getIndexFullQualifiedName(FlowNodeInstanceTemplate::new), this.getIndexFullQualifiedName(ListViewTemplate::new), this.getIndexFullQualifiedName(SnapshotTaskVariableTemplate::new), this.getIndexFullQualifiedName(TaskTemplate::new), this.getIndexFullQualifiedName(TasklistMetricIndex::new), this.getIndexFullQualifiedName(UsageMetricTUTemplate::new), this.getIndexFullQualifiedName(VariableTemplate::new));
        try (ElasticsearchClient elasticsearchClient = connector.createClient();){
            ElasticsearchEngineClient searchEngineClient = new ElasticsearchEngineClient(elasticsearchClient, connector.objectMapper());
            elasticsearchClient.indices().delete(r -> r.index(indicesToDelete));
            this.processCache.clearCache();
            try (SchemaManager schemaManager = new SchemaManager((SearchEngineClient)searchEngineClient, indexDescriptors.indices(), indexDescriptors.templates(), this.configuration, connector.objectMapper());){
                schemaManager.startup();
            }
        }
        return ResponseEntity.ok().build();
    }

    private <T extends AbstractIndexDescriptor> String getIndexFullQualifiedName(BiFunction<String, Boolean, T> constructor) {
        return ((AbstractIndexDescriptor)constructor.apply(this.configuration.connect().getIndexPrefix(), true)).getFullQualifiedName();
    }
}

