/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.api.rest.v1.controllers;

import io.camunda.spring.utils.ConditionalOnRdbmsDisabled;
import io.camunda.tasklist.webapp.api.rest.v1.controllers.ApiErrorController;
import io.camunda.tasklist.webapp.api.rest.v1.entities.VariableResponse;
import io.camunda.tasklist.webapp.permission.TasklistPermissionServices;
import io.camunda.tasklist.webapp.rest.exception.Error;
import io.camunda.tasklist.webapp.rest.exception.ForbiddenActionException;
import io.camunda.tasklist.webapp.service.VariableService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Variables", description="API to query variables.")
@RestController
@RequestMapping(value={"/v1/variables"}, produces={"application/json"})
@ConditionalOnRdbmsDisabled
public class VariablesController
extends ApiErrorController {
    @Autowired
    private VariableService variableService;
    @Autowired
    private TasklistPermissionServices tasklistPermissionServices;

    @Operation(summary="Get a variable", description="Get the variable details by variable id.", responses={@ApiResponse(description="On success returned.", responseCode="200", useReturnTypeSchema=true), @ApiResponse(description="An error is returned when the variable with the `variableId` is not found.", responseCode="404", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))})})
    @GetMapping(value={"{variableId}"})
    public ResponseEntity<VariableResponse> getVariableById(@PathVariable @Parameter(description="The ID of the variable.", required=true) String variableId) {
        if (!this.tasklistPermissionServices.hasWildcardPermissionToReadUserTask()) {
            throw new ForbiddenActionException("User does not have permission to read resource. Please check your permissions.");
        }
        VariableResponse variable = this.variableService.getVariableResponse(variableId);
        return ResponseEntity.ok((Object)variable);
    }
}

