/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.api.rest.v1.controllers;

import io.camunda.tasklist.exceptions.NotFoundException;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.webapp.rest.exception.APIException;
import io.camunda.tasklist.webapp.rest.exception.Error;
import io.camunda.tasklist.webapp.rest.exception.ForbiddenActionException;
import io.camunda.tasklist.webapp.rest.exception.InvalidRequestException;
import io.camunda.tasklist.webapp.rest.exception.NotFoundApiException;
import io.camunda.tasklist.webapp.rest.exception.UnauthenticatedUserException;
import io.swagger.v3.oas.annotations.Hidden;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;

public abstract class ApiErrorController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Hidden
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={TasklistRuntimeException.class})
    public ResponseEntity<Error> handleException(TasklistRuntimeException exception) {
        this.logger.warn(exception.getMessage(), (Throwable)exception);
        Error error = new Error().setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value()).setMessage(exception.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.APPLICATION_PROBLEM_JSON).body((Object)error);
    }

    @Hidden
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<Error> handleException(HttpMessageNotReadableException exception) {
        this.logger.warn(exception.getMessage(), (Throwable)exception);
        Error error = new Error().setStatus(HttpStatus.BAD_REQUEST.value()).setMessage(exception.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_PROBLEM_JSON).body((Object)error);
    }

    @Hidden
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={NotFoundException.class})
    public ResponseEntity<Error> handleNotFound(NotFoundException exception) {
        return this.handleNotFound(new NotFoundApiException(exception.getMessage(), (Throwable)exception));
    }

    @Hidden
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Error> handleException(Exception exception) {
        this.logger.error(String.format("Unexpected exception happened: %s", exception.getMessage()), (Throwable)exception);
        Error error = new Error().setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value()).setMessage("Unexpected server error occurred.");
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.APPLICATION_PROBLEM_JSON).body((Object)error);
    }

    @Hidden
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={APIException.class})
    public ResponseEntity<Error> handleAPIException(APIException exception) {
        this.logAPIException(exception);
        Error error = new Error().setStatus(HttpStatus.BAD_REQUEST.value()).setInstance(exception.getInstance()).setMessage(exception.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_PROBLEM_JSON).body((Object)error);
    }

    @Hidden
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ResponseEntity<Error> handleMissingRequestParameterException(MissingServletRequestParameterException exception) {
        this.logger.warn(exception.getMessage(), (Throwable)exception);
        return this.handleAPIException(new InvalidRequestException(exception.getMessage()));
    }

    private void logAPIException(APIException exception) {
        this.logger.warn(String.format("Instance: %s; %s", exception.getInstance(), exception.getMessage()), (Throwable)exception);
    }

    @Hidden
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ExceptionHandler(value={UnauthenticatedUserException.class})
    public ResponseEntity<Error> handleUnauthenticatedUserException(UnauthenticatedUserException exception) {
        this.logger.warn(exception.getMessage(), (Throwable)exception);
        Error error = new Error().setInstance(UUID.randomUUID().toString()).setStatus(HttpStatus.UNAUTHORIZED.value()).setMessage(exception.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).contentType(MediaType.APPLICATION_PROBLEM_JSON).body((Object)error);
    }

    @Hidden
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={ForbiddenActionException.class})
    public ResponseEntity<Error> handleForbiddenActionException(ForbiddenActionException exception) {
        this.logAPIException(exception);
        Error error = new Error().setInstance(exception.getInstance()).setStatus(HttpStatus.FORBIDDEN.value()).setMessage(exception.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).contentType(MediaType.APPLICATION_PROBLEM_JSON).body((Object)error);
    }

    @Hidden
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={NotFoundApiException.class})
    public ResponseEntity<Error> handleNotFound(NotFoundApiException exception) {
        this.logAPIException(exception);
        Error error = new Error().setInstance(exception.getInstance()).setStatus(HttpStatus.NOT_FOUND.value()).setMessage(exception.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).contentType(MediaType.APPLICATION_PROBLEM_JSON).body((Object)error);
    }
}

