/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.service;

import io.camunda.client.impl.command.StreamUtil;
import io.camunda.security.auth.CamundaAuthentication;
import io.camunda.security.auth.CamundaAuthenticationProvider;
import io.camunda.service.JobServices;
import io.camunda.service.ProcessInstanceServices;
import io.camunda.service.ResourceServices;
import io.camunda.service.UserTaskServices;
import io.camunda.service.exception.ServiceException;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.util.ConditionalOnTasklistCompatibility;
import io.camunda.tasklist.webapp.permission.TasklistPermissionServices;
import io.camunda.tasklist.webapp.rest.exception.ForbiddenActionException;
import io.camunda.tasklist.webapp.rest.exception.InvalidRequestException;
import io.camunda.tasklist.webapp.rest.exception.NotFoundApiException;
import io.camunda.tasklist.webapp.tenant.TenantService;
import io.camunda.tasklist.webapp.util.ErrorHandlingUtils;
import io.camunda.tasklist.zeebe.TasklistServicesAdapter;
import io.camunda.webapps.schema.entities.usertask.TaskEntity;
import io.camunda.zeebe.gateway.rest.validator.MultiTenancyValidator;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.util.Either;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import org.springframework.http.ProblemDetail;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnTasklistCompatibility(enabled="false", matchIfMissing=true)
public class CamundaServicesBasedAdapter
implements TasklistServicesAdapter {
    private final TenantService tenantService;
    private final ProcessInstanceServices processInstanceServices;
    private final ResourceServices resourceServices;
    private final UserTaskServices userTaskServices;
    private final JobServices<?> jobServices;
    private final TasklistPermissionServices permissionServices;
    private final CamundaAuthenticationProvider authenticationProvider;

    public CamundaServicesBasedAdapter(TenantService tenantService, ProcessInstanceServices processInstanceServices, ResourceServices resourceServices, UserTaskServices userTaskServices, JobServices<?> jobServices, TasklistPermissionServices permissionServices, CamundaAuthenticationProvider authenticationProvider) {
        this.tenantService = tenantService;
        this.processInstanceServices = processInstanceServices;
        this.resourceServices = resourceServices;
        this.userTaskServices = userTaskServices;
        this.jobServices = jobServices;
        this.permissionServices = permissionServices;
        this.authenticationProvider = authenticationProvider;
    }

    public ProcessInstanceCreationRecord createProcessInstance(String bpmnProcessId, Map<String, Object> variables, String tenantId) {
        return (ProcessInstanceCreationRecord)this.executeCamundaServiceAuthenticated(authentication -> this.processInstanceServices.withAuthentication(authentication).createProcessInstance(this.toProcessInstanceCreateRequest(bpmnProcessId, variables, tenantId)));
    }

    public ProcessInstanceCreationRecord createProcessInstanceWithoutAuthentication(String bpmnProcessId, Map<String, Object> variables, String tenantId) {
        return (ProcessInstanceCreationRecord)this.executeCamundaServiceAnonymously(authentication -> this.processInstanceServices.withAuthentication(authentication).createProcessInstance(this.toProcessInstanceCreateRequest(bpmnProcessId, variables, tenantId)));
    }

    public void assignUserTask(TaskEntity task, String assignee) {
        if (!this.isJobBasedUserTask(task)) {
            this.assignCamundaUserTask(task, assignee);
        } else if (this.isNotAuthorizedToAssignJobBasedUserTask(task)) {
            throw new ForbiddenActionException("Not allowed to assign user task.");
        }
    }

    public void unassignUserTask(TaskEntity task) {
        if (!this.isJobBasedUserTask(task)) {
            this.unassignCamundaUserTask(task);
        } else if (this.isNotAuthorizedToUnassignJobBasedUserTask(task)) {
            throw new ForbiddenActionException("Not allowed to unassign user task.");
        }
    }

    public void completeUserTask(TaskEntity task, Map<String, Object> variables) {
        if (this.isJobBasedUserTask(task)) {
            this.completeJobBasedUserTask(task, variables);
        } else {
            this.completeCamundaUserTask(task, variables);
        }
    }

    public void deployResourceWithoutAuthentication(String classpathResource, String tenantId) {
        block9: {
            try (InputStream resourceStream = this.getClass().getClassLoader().getResourceAsStream(classpathResource);){
                if (resourceStream != null) {
                    byte[] bytes = StreamUtil.readInputStream((InputStream)resourceStream);
                    this.executeCamundaServiceAnonymously(authentication -> this.resourceServices.withAuthentication(authentication).deployResources(this.toDeployResourcesRequest(classpathResource, bytes, tenantId)));
                    break block9;
                }
                throw new FileNotFoundException(classpathResource);
            }
            catch (IOException e) {
                String exceptionMsg = String.format("Cannot deploy resource from classpath. %s", e.getMessage());
                throw new TasklistRuntimeException(exceptionMsg, (Throwable)e);
            }
        }
    }

    private boolean isNotAuthorizedToAssignJobBasedUserTask(TaskEntity task) {
        return !this.permissionServices.hasPermissionToUpdateUserTask(task);
    }

    private void assignCamundaUserTask(TaskEntity task, String assignee) {
        this.executeCamundaServiceAuthenticated(authentication -> this.userTaskServices.withAuthentication(authentication).assignUserTask(task.getKey(), assignee, "", true));
    }

    private boolean isNotAuthorizedToUnassignJobBasedUserTask(TaskEntity task) {
        return !this.permissionServices.hasPermissionToUpdateUserTask(task);
    }

    private void unassignCamundaUserTask(TaskEntity task) {
        this.executeCamundaServiceAuthenticated(authentication -> this.userTaskServices.withAuthentication(authentication).unassignUserTask(task.getKey(), ""));
    }

    private boolean isNotAuthorizedToCompleteJobBasedUserTask(TaskEntity task) {
        return !this.permissionServices.hasPermissionToUpdateUserTask(task);
    }

    private void completeJobBasedUserTask(TaskEntity task, Map<String, Object> variables) {
        if (this.isNotAuthorizedToCompleteJobBasedUserTask(task)) {
            throw new ForbiddenActionException("Not allowed to complete user task.");
        }
        this.executeCamundaServiceAnonymously(authentication -> this.jobServices.withAuthentication(authentication).completeJob(task.getKey(), variables, null));
    }

    private void completeCamundaUserTask(TaskEntity task, Map<String, Object> variables) {
        this.executeCamundaServiceAuthenticated(authentication -> this.userTaskServices.withAuthentication(authentication).completeUserTask(task.getKey(), variables, ""));
    }

    private ProcessInstanceServices.ProcessInstanceCreateRequest toProcessInstanceCreateRequest(String bpmnProcessId, Map<String, Object> variables, String tenantId) {
        Either tenantValidationResult = MultiTenancyValidator.validateTenantId((String)tenantId, (boolean)this.tenantService.isMultiTenancyEnabled(), (String)"Create Process Instance");
        if (tenantValidationResult.isLeft()) {
            throw new InvalidRequestException(((ProblemDetail)tenantValidationResult.getLeft()).getDetail());
        }
        String tenant = (String)tenantValidationResult.get();
        return new ProcessInstanceServices.ProcessInstanceCreateRequest(Long.valueOf(-1L), bpmnProcessId, Integer.valueOf(-1), variables, tenant, null, null, null, List.of(), List.of(), null, Set.of());
    }

    private ResourceServices.DeployResourcesRequest toDeployResourcesRequest(String classpathResource, byte[] bytes, String tenantId) {
        Either tenantValidationResult = MultiTenancyValidator.validateTenantId((String)tenantId, (boolean)this.tenantService.isMultiTenancyEnabled(), (String)"Deploy Resources");
        if (tenantValidationResult.isLeft()) {
            throw new InvalidRequestException(((ProblemDetail)tenantValidationResult.getLeft()).getDetail());
        }
        String tenant = (String)tenantValidationResult.get();
        return new ResourceServices.DeployResourcesRequest(Map.of(classpathResource, bytes), tenant);
    }

    private <T> T executeCamundaServiceAuthenticated(Function<CamundaAuthentication, CompletableFuture<T>> method) {
        return this.executeCamundaService(method, this.authenticationProvider.getCamundaAuthentication());
    }

    private <T> T executeCamundaServiceAnonymously(Function<CamundaAuthentication, CompletableFuture<T>> method) {
        return this.executeCamundaService(method, this.authenticationProvider.getAnonymousCamundaAuthentication());
    }

    private <T> T executeCamundaService(Function<CamundaAuthentication, CompletableFuture<T>> method, CamundaAuthentication authentication) {
        try {
            return method.apply(authentication).join();
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    private RuntimeException handleException(Throwable error) {
        Throwable throwable = error;
        Objects.requireNonNull(throwable);
        Throwable throwable2 = throwable;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CompletionException.class, ServiceException.class}, (Object)throwable2, n)) {
            case 0 -> {
                CompletionException ce = (CompletionException)throwable2;
                yield this.handleException(ce.getCause());
            }
            case 1 -> {
                ServiceException se = (ServiceException)throwable2;
                yield this.mapServiceException(se);
            }
            default -> new RuntimeException("Failed to execute request: " + error.getMessage(), error);
        };
    }

    private RuntimeException mapServiceException(ServiceException exception) {
        return switch (exception.getStatus()) {
            case ServiceException.Status.NOT_FOUND -> new NotFoundApiException(exception.getMessage(), (Throwable)exception);
            case ServiceException.Status.FORBIDDEN, ServiceException.Status.UNAUTHORIZED -> new ForbiddenActionException(exception.getMessage(), (Throwable)exception);
            default -> new TasklistRuntimeException(ErrorHandlingUtils.getErrorMessageFromServiceException(exception));
        };
    }
}

