/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security;

import io.camunda.security.entity.AuthenticationMethod;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class TasklistProfileService {
    @Autowired
    private Environment environment;

    public String getMessageByProfileFor(Exception exception) {
        if (this.isDevelopmentProfileActive()) {
            return exception.getMessage();
        }
        return "";
    }

    public boolean currentProfileCanLogout() {
        return true;
    }

    public boolean isLoginDelegated() {
        Optional consolidatedAuthVariation = AuthenticationMethod.parse((String)this.environment.getProperty("camunda.security.authentication.method"));
        return consolidatedAuthVariation.isPresent() && AuthenticationMethod.OIDC.equals(consolidatedAuthVariation.get());
    }

    private boolean isDevelopmentProfileActive() {
        return List.of(this.environment.getActiveProfiles()).contains("dev");
    }
}

