/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.webapp.rest.ClientConfig;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ClientConfigRestService {
    public static final String CLIENT_CONFIG_RESOURCE = "/tasklist/client-config.js";
    @Autowired
    private ClientConfig clientConfig;
    private String clientConfigAsJS;

    @PostConstruct
    public void init() {
        try {
            this.clientConfigAsJS = String.format("window.clientConfig = %s;", new ObjectMapper().writeValueAsString((Object)this.clientConfig));
        }
        catch (JsonProcessingException e) {
            this.clientConfigAsJS = "window.clientConfig = {};";
        }
    }

    @Hidden
    @GetMapping(path={"/tasklist/client-config.js"}, produces={"text/javascript"})
    public String getClientConfig() {
        return this.clientConfigAsJS;
    }
}

