/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.rest;

import io.camunda.security.configuration.SecurityConfiguration;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.webapp.security.TasklistProfileService;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.unit.DataSize;

@Component
public class ClientConfig {
    public boolean isEnterprise;
    public boolean isMultiTenancyEnabled;
    public boolean canLogout;
    public boolean isLoginDelegated;
    public String contextPath;
    public String baseName;
    public String clientMode;
    @Value(value="${CAMUNDA_TASKLIST_CLOUD_ORGANIZATIONID:#{null}}")
    public String organizationId;
    @Value(value="${CAMUNDA_TASKLIST_CLOUD_CLUSTERID:#{null}}")
    public String clusterId;
    @Value(value="${CAMUNDA_TASKLIST_CLOUD_STAGE:#{null}}")
    public String stage;
    @Value(value="${CAMUNDA_TASKLIST_CLOUD_MIXPANELTOKEN:#{null}}")
    public String mixpanelToken;
    @Value(value="${CAMUNDA_TASKLIST_CLOUD_MIXPANELAPIHOST:#{null}}")
    public String mixpanelAPIHost;
    @Value(value="${CAMUNDA_TASKLIST_IDENTITY_RESOURCE_PERMISSIONS_ENABLED:#{false}}")
    public boolean isResourcePermissionsEnabled;
    @Value(value="${CAMUNDA_TASKLIST_IDENTITY_USER_ACCESS_RESTRICTIONS_ENABLED:#{true}}")
    public boolean isUserAccessRestrictionsEnabled;
    public long maxRequestSize;
    @Value(value="${spring.servlet.multipart.max-request-size:4MB}")
    private DataSize maxRequestSizeConfigValue;
    @Value(value="${CAMUNDA_TASKLIST_V2_MODE_ENABLED:#{false}}")
    private boolean isV2ModeEnabled;
    @Autowired
    private TasklistProfileService profileService;
    @Autowired
    private TasklistProperties tasklistProperties;
    @Autowired
    private SecurityConfiguration securityConfiguration;
    @Autowired
    private ServletContext context;

    @PostConstruct
    public void init() {
        this.isEnterprise = this.tasklistProperties.isEnterprise();
        this.isMultiTenancyEnabled = this.securityConfiguration.getMultiTenancy().isChecksEnabled();
        this.contextPath = this.context.getContextPath();
        this.baseName = this.context.getContextPath() + "/tasklist";
        this.canLogout = this.profileService.currentProfileCanLogout();
        this.isLoginDelegated = this.profileService.isLoginDelegated();
        this.maxRequestSize = this.maxRequestSizeConfigValue.toBytes();
        this.clientMode = this.isV2ModeEnabled ? "v2" : "v1";
    }
}

