/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.es;

import io.camunda.security.auth.CamundaAuthentication;
import io.camunda.security.auth.CamundaAuthenticationProvider;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.webapp.rest.exception.InvalidRequestException;
import io.camunda.tasklist.webapp.security.TasklistAuthenticationUtil;
import io.camunda.tasklist.webapp.util.ErrorHandlingUtils;
import io.camunda.webapps.schema.entities.usertask.TaskEntity;
import io.camunda.webapps.schema.entities.usertask.TaskState;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskValidator {
    @Autowired
    private CamundaAuthenticationProvider authenticationProvider;
    @Autowired
    private TasklistProperties tasklistProperties;

    public TaskValidator(CamundaAuthenticationProvider authenticationProvider, TasklistProperties tasklistProperties) {
        this.authenticationProvider = authenticationProvider;
        this.tasklistProperties = tasklistProperties;
    }

    public void validateCanPersistDraftTaskVariables(TaskEntity task) {
        this.validateTaskStateAndAssignment(task);
    }

    public void validateCanComplete(TaskEntity taskBefore) {
        this.validateTaskStateAndAssignment(taskBefore);
    }

    private void validateTaskStateAndAssignment(TaskEntity task) {
        TaskValidator.validateTaskIsActive(task);
        if (TasklistAuthenticationUtil.isApiUser(this.authenticationProvider.getCamundaAuthentication())) {
            return;
        }
        TaskValidator.validateTaskIsAssigned(task);
        CamundaAuthentication currentAuthentication = this.authenticationProvider.getCamundaAuthentication();
        String authenticatedUsername = currentAuthentication.authenticatedUsername();
        if (!task.getAssignee().equals(authenticatedUsername) && !this.tasklistProperties.getFeatureFlag().getAllowNonSelfAssignment().booleanValue()) {
            throw new InvalidRequestException(ErrorHandlingUtils.createErrorMessage("TASK_NOT_ASSIGNED_TO_CURRENT_USER", "Task is not assigned to " + authenticatedUsername));
        }
    }

    public void validateCanAssign(TaskEntity taskBefore, boolean allowOverrideAssignment) {
        TaskValidator.validateTaskIsActive(taskBefore);
        if ((TasklistAuthenticationUtil.isApiUser(this.authenticationProvider.getCamundaAuthentication()) || this.tasklistProperties.getFeatureFlag().getAllowNonSelfAssignment().booleanValue()) && allowOverrideAssignment) {
            return;
        }
        if (taskBefore.getAssignee() != null) {
            throw new InvalidRequestException(ErrorHandlingUtils.createErrorMessage("TASK_ALREADY_ASSIGNED", "Task is already assigned"));
        }
    }

    public void validateCanUnassign(TaskEntity taskBefore) {
        TaskValidator.validateTaskIsActive(taskBefore);
        TaskValidator.validateTaskIsAssigned(taskBefore);
    }

    private static void validateTaskIsActive(TaskEntity taskBefore) {
        if (!taskBefore.getState().equals((Object)TaskState.CREATED)) {
            throw new InvalidRequestException(ErrorHandlingUtils.createErrorMessage("TASK_IS_NOT_ACTIVE", "Task is not active"));
        }
    }

    private static void validateTaskIsAssigned(TaskEntity taskBefore) {
        if (taskBefore.getAssignee() == null) {
            throw new InvalidRequestException(ErrorHandlingUtils.createErrorMessage("TASK_NOT_ASSIGNED", "Task is not assigned"));
        }
    }
}

