/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.dto;

import io.camunda.webapps.schema.entities.VariableEntity;
import io.camunda.webapps.schema.entities.usertask.SnapshotTaskVariableEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class VariableDTO {
    private String id;
    private String name;
    private String value;
    private boolean isValueTruncated;
    private String previewValue;

    public String getId() {
        return this.id;
    }

    public VariableDTO setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public VariableDTO setName(String name) {
        this.name = name;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public VariableDTO setValue(String value) {
        this.value = value;
        return this;
    }

    public boolean getIsValueTruncated() {
        return this.isValueTruncated;
    }

    public VariableDTO setIsValueTruncated(boolean valueTruncated) {
        this.isValueTruncated = valueTruncated;
        return this;
    }

    public String getPreviewValue() {
        return this.previewValue;
    }

    public VariableDTO setPreviewValue(String previewValue) {
        this.previewValue = previewValue;
        return this;
    }

    public static VariableDTO createFrom(SnapshotTaskVariableEntity variableEntity) {
        VariableDTO variableDTO = new VariableDTO().setId(variableEntity.getId()).setName(variableEntity.getName());
        variableDTO.setPreviewValue(variableEntity.getValue()).setIsValueTruncated(variableEntity.getIsPreview()).setValue(variableEntity.getFullValue());
        return variableDTO;
    }

    public static VariableDTO createFrom(VariableEntity variableEntity) {
        VariableDTO variableDTO = new VariableDTO().setId(variableEntity.getId()).setName(variableEntity.getName());
        variableDTO.setPreviewValue(variableEntity.getValue()).setIsValueTruncated(variableEntity.getIsPreview()).setValue(variableEntity.getIsPreview() ? variableEntity.getFullValue() : variableEntity.getValue());
        return variableDTO;
    }

    public static List<VariableDTO> createFrom(List<VariableEntity> variableEntities) {
        ArrayList<VariableDTO> result = new ArrayList<VariableDTO>();
        if (variableEntities != null) {
            for (VariableEntity variableEntity : variableEntities) {
                if (variableEntity == null) continue;
                result.add(VariableDTO.createFrom(variableEntity));
            }
        }
        return result;
    }

    public static List<VariableDTO> createFromTaskVariables(List<SnapshotTaskVariableEntity> taskVariableEntities) {
        return taskVariableEntities.stream().map(VariableDTO::createFrom).collect(Collectors.toList());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.value, this.isValueTruncated, this.previewValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableDTO that = (VariableDTO)o;
        return this.isValueTruncated == that.isValueTruncated && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.previewValue, that.previewValue);
    }
}

