/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.dto;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.util.CollectionUtil;
import io.camunda.tasklist.views.TaskSearchView;
import io.camunda.tasklist.webapp.dto.VariableDTO;
import io.camunda.webapps.schema.entities.usertask.TaskEntity;
import io.camunda.webapps.schema.entities.usertask.TaskState;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;

public final class TaskDTO {
    private String id;
    private String processInstanceId;
    private String flowNodeBpmnId;
    private String flowNodeInstanceId;
    private String processDefinitionId;
    private String bpmnProcessId;
    private String creationTime;
    private String completionTime;
    private String assignee;
    private String[] candidateGroups;
    private String[] candidateUsers;
    private TaskState taskState;
    private String[] sortValues;
    private boolean isFirst = false;
    private String formKey;
    private String formId;
    private Long formVersion;
    private Boolean isFormEmbedded;
    private String tenantId;
    private OffsetDateTime dueDate;
    private OffsetDateTime followUpDate;
    private String externalFormReference;
    private VariableDTO[] variables;
    private TaskEntity.TaskImplementation implementation;
    private int priority;

    public String getId() {
        return this.id;
    }

    public TaskDTO setId(String id) {
        this.id = id;
        return this;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public TaskDTO setAssignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    public String[] getCandidateGroups() {
        return this.candidateGroups;
    }

    public TaskDTO setCandidateGroups(String[] candidateGroups) {
        this.candidateGroups = candidateGroups;
        return this;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public TaskDTO setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    public String getFlowNodeBpmnId() {
        return this.flowNodeBpmnId;
    }

    public TaskDTO setFlowNodeBpmnId(String flowNodeBpmnId) {
        this.flowNodeBpmnId = flowNodeBpmnId;
        return this;
    }

    public String getFlowNodeInstanceId() {
        return this.flowNodeInstanceId;
    }

    public TaskDTO setFlowNodeInstanceId(String flowNodeInstanceId) {
        this.flowNodeInstanceId = flowNodeInstanceId;
        return this;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public TaskDTO setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    public TaskDTO setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
        return this;
    }

    public String getCreationTime() {
        return this.creationTime;
    }

    public TaskDTO setCreationTime(String creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public String getCompletionTime() {
        return this.completionTime;
    }

    public TaskDTO setCompletionTime(String completionTime) {
        this.completionTime = completionTime;
        return this;
    }

    public TaskState getTaskState() {
        return this.taskState;
    }

    public TaskDTO setTaskState(TaskState taskState) {
        this.taskState = taskState;
        return this;
    }

    public String[] getSortValues() {
        return this.sortValues;
    }

    public TaskDTO setSortValues(String[] sortValues) {
        this.sortValues = sortValues;
        return this;
    }

    public boolean getIsFirst() {
        return this.isFirst;
    }

    public TaskDTO setIsFirst(boolean first) {
        this.isFirst = first;
        return this;
    }

    public String[] candidateUsers() {
        return this.candidateUsers;
    }

    public String[] getCandidateUsers() {
        return this.candidateUsers;
    }

    public TaskDTO setCandidateUsers(String[] candidateUsers) {
        this.candidateUsers = candidateUsers;
        return this;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public TaskDTO setFormKey(String formKey) {
        this.formKey = formKey;
        return this;
    }

    public String getFormId() {
        return this.formId;
    }

    public TaskDTO setFormId(String formId) {
        this.formId = formId;
        return this;
    }

    public Long getFormVersion() {
        return this.formVersion;
    }

    public TaskDTO setFormVersion(Long formVersion) {
        this.formVersion = formVersion;
        return this;
    }

    public Boolean getIsFormEmbedded() {
        return this.isFormEmbedded;
    }

    public TaskDTO setIsFormEmbedded(Boolean isFormEmbedded) {
        this.isFormEmbedded = isFormEmbedded;
        return this;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public TaskDTO setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public OffsetDateTime getDueDate() {
        return this.dueDate;
    }

    public TaskDTO setDueDate(OffsetDateTime dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    public OffsetDateTime getFollowUpDate() {
        return this.followUpDate;
    }

    public TaskDTO setFollowUpDate(OffsetDateTime followUpDate) {
        this.followUpDate = followUpDate;
        return this;
    }

    public VariableDTO[] getVariables() {
        return this.variables;
    }

    public TaskDTO setVariables(VariableDTO[] variables) {
        this.variables = variables;
        return this;
    }

    public TaskEntity.TaskImplementation getImplementation() {
        return this.implementation;
    }

    public TaskDTO setImplementation(TaskEntity.TaskImplementation implementation) {
        this.implementation = implementation;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public TaskDTO setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public String getExternalFormReference() {
        return this.externalFormReference;
    }

    public TaskDTO setExternalFormReference(String externalFormReference) {
        this.externalFormReference = externalFormReference;
        return this;
    }

    public static TaskDTO createFrom(TaskEntity taskEntity, ObjectMapper objectMapper) {
        return TaskDTO.createFrom(taskEntity, null, objectMapper);
    }

    public static TaskDTO createFrom(TaskEntity taskEntity, Object[] sortValues, ObjectMapper objectMapper) {
        TaskDTO taskDTO = new TaskDTO().setCreationTime((String)objectMapper.convertValue((Object)taskEntity.getCreationTime(), String.class)).setCompletionTime((String)objectMapper.convertValue((Object)taskEntity.getCompletionTime(), String.class)).setId(String.valueOf(taskEntity.getKey())).setProcessInstanceId(taskEntity.getProcessInstanceId()).setTaskState(taskEntity.getState()).setAssignee(taskEntity.getAssignee()).setBpmnProcessId(taskEntity.getBpmnProcessId()).setProcessDefinitionId(taskEntity.getProcessDefinitionId()).setFlowNodeBpmnId(taskEntity.getFlowNodeBpmnId()).setFlowNodeInstanceId(taskEntity.getFlowNodeInstanceId()).setFormKey(taskEntity.getFormKey()).setFormId(taskEntity.getFormId()).setFormVersion(taskEntity.getFormVersion()).setIsFormEmbedded(taskEntity.getIsFormEmbedded()).setTenantId(taskEntity.getTenantId()).setFollowUpDate(taskEntity.getFollowUpDate()).setDueDate(taskEntity.getDueDate()).setCandidateGroups(taskEntity.getCandidateGroups()).setCandidateUsers(taskEntity.getCandidateUsers()).setImplementation(taskEntity.getImplementation()).setExternalFormReference(taskEntity.getExternalFormReference()).setPriority(taskEntity.getPriority() == null ? 50 : taskEntity.getPriority());
        if (sortValues != null) {
            taskDTO.setSortValues(CollectionUtil.toArrayOfStrings((Object[])sortValues));
        }
        return taskDTO;
    }

    public static TaskDTO createFrom(TaskSearchView taskSearchView, VariableDTO[] variables, ObjectMapper objectMapper) {
        return new TaskDTO().setCreationTime((String)objectMapper.convertValue((Object)taskSearchView.getCreationTime(), String.class)).setCompletionTime((String)objectMapper.convertValue((Object)taskSearchView.getCompletionTime(), String.class)).setId(taskSearchView.getId()).setProcessInstanceId(taskSearchView.getProcessInstanceId()).setTaskState(taskSearchView.getState()).setAssignee(taskSearchView.getAssignee()).setBpmnProcessId(taskSearchView.getBpmnProcessId()).setProcessDefinitionId(taskSearchView.getProcessDefinitionId()).setFlowNodeBpmnId(taskSearchView.getFlowNodeBpmnId()).setFlowNodeInstanceId(taskSearchView.getFlowNodeInstanceId()).setFormKey(taskSearchView.getFormKey()).setFormId(taskSearchView.getFormId()).setFormVersion(taskSearchView.getFormVersion()).setIsFormEmbedded(taskSearchView.getIsFormEmbedded()).setTenantId(taskSearchView.getTenantId()).setFollowUpDate(taskSearchView.getFollowUpDate()).setDueDate(taskSearchView.getDueDate()).setCandidateGroups(taskSearchView.getCandidateGroups()).setCandidateUsers(taskSearchView.getCandidateUsers()).setSortValues(taskSearchView.getSortValues()).setIsFirst(taskSearchView.isFirst()).setVariables(variables).setImplementation(taskSearchView.getImplementation()).setPriority(taskSearchView.getPriority() == null ? 50 : taskSearchView.getPriority()).setExternalFormReference(taskSearchView.getExternalFormReference());
    }

    public int hashCode() {
        int result = Objects.hash(this.id, this.processInstanceId, this.flowNodeBpmnId, this.flowNodeInstanceId, this.processDefinitionId, this.bpmnProcessId, this.creationTime, this.completionTime, this.assignee, this.taskState, this.isFirst, this.formKey, this.formId, this.formVersion, this.isFormEmbedded, this.tenantId, this.dueDate, this.followUpDate, this.implementation, this.priority, this.externalFormReference);
        result = 31 * result + Arrays.hashCode(this.candidateGroups);
        result = 31 * result + Arrays.hashCode(this.candidateUsers);
        result = 31 * result + Arrays.hashCode(this.sortValues);
        result = 31 * result + Arrays.hashCode(this.variables);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskDTO taskDTO = (TaskDTO)o;
        return this.isFirst == taskDTO.isFirst && this.implementation == taskDTO.implementation && Objects.equals(this.id, taskDTO.id) && Objects.equals(this.processInstanceId, taskDTO.processInstanceId) && Objects.equals(this.flowNodeBpmnId, taskDTO.flowNodeBpmnId) && Objects.equals(this.flowNodeInstanceId, taskDTO.flowNodeInstanceId) && Objects.equals(this.processDefinitionId, taskDTO.processDefinitionId) && Objects.equals(this.bpmnProcessId, taskDTO.bpmnProcessId) && Objects.equals(this.creationTime, taskDTO.creationTime) && Objects.equals(this.completionTime, taskDTO.completionTime) && Objects.equals(this.assignee, taskDTO.assignee) && Arrays.equals(this.candidateGroups, taskDTO.candidateGroups) && Arrays.equals(this.candidateUsers, taskDTO.candidateUsers) && this.taskState == taskDTO.taskState && Arrays.equals(this.sortValues, taskDTO.sortValues) && Objects.equals(this.formKey, taskDTO.formKey) && Objects.equals(this.formId, taskDTO.formId) && Objects.equals(this.formVersion, taskDTO.formVersion) && Objects.equals(this.isFormEmbedded, taskDTO.isFormEmbedded) && Objects.equals(this.tenantId, taskDTO.tenantId) && Objects.equals(this.dueDate, taskDTO.dueDate) && Objects.equals(this.followUpDate, taskDTO.followUpDate) && this.priority == taskDTO.priority && Arrays.equals(this.variables, taskDTO.variables) && Objects.equals(this.externalFormReference, taskDTO.externalFormReference);
    }

    public String toString() {
        return new StringJoiner(", ", TaskDTO.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("processInstanceId='" + this.processInstanceId + "'").add("flowNodeBpmnId='" + this.flowNodeBpmnId + "'").add("flowNodeInstanceId='" + this.flowNodeInstanceId + "'").add("processDefinitionId='" + this.processDefinitionId + "'").add("bpmnProcessId='" + this.bpmnProcessId + "'").add("creationTime='" + this.creationTime + "'").add("completionTime='" + this.completionTime + "'").add("assignee='" + this.assignee + "'").add("candidateGroups=" + Arrays.toString(this.candidateGroups)).add("candidateUsers=" + Arrays.toString(this.candidateUsers)).add("taskState=" + String.valueOf(this.taskState)).add("sortValues=" + Arrays.toString(this.sortValues)).add("isFirst=" + this.isFirst).add("formKey='" + this.formKey + "'").add("formId='" + this.formId + "'").add("formVersion='" + this.formVersion + "'").add("isFormEmbedded='" + this.isFormEmbedded + "'").add("tenantId='" + this.tenantId + "'").add("dueDate=" + String.valueOf(this.dueDate)).add("followUpDate=" + String.valueOf(this.followUpDate)).add("variables=" + Arrays.toString(this.variables)).add("implementation=" + String.valueOf(this.implementation)).add("priority=" + this.priority).add("externalFormReference='" + this.externalFormReference + "'").toString();
    }
}

