/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.api.rest.v1.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.camunda.tasklist.webapp.api.rest.v1.entities.VariableSearchResponse;
import io.camunda.webapps.schema.entities.usertask.TaskEntity;
import io.camunda.webapps.schema.entities.usertask.TaskState;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;

public class TaskSearchResponse {
    @Schema(description="The unique identifier of the task.")
    private String id;
    @Schema(description="The name of the task.")
    private String name;
    @Schema(description="User Task ID from the BPMN definition.")
    private String taskDefinitionId;
    @Schema(description="The name of the process.")
    private String processName;
    @Schema(description="When was the task created (renamed equivalent of `Task.creationTime` field).")
    private String creationDate;
    @Schema(description="When was the task completed (renamed equivalent of `Task.completionTime` field).")
    private String completionDate;
    @Schema(description="The username/id of who is assigned to the task.")
    private String assignee;
    @Schema(description="The state of the task.")
    private TaskState taskState;
    @ArraySchema(arraySchema=@Schema(description="Array of values to be copied into `TaskSearchRequest` to request for next or previous page of tasks."))
    private String[] sortValues;
    @Schema(description="A flag to show that the task is first in the current filter.")
    private boolean isFirst;
    @Schema(description="Reference to the task form.")
    private String formKey;
    @Schema(description="Reference to the ID of a deployed form. If the form is not deployed, this property is null.")
    private String formId;
    @Schema(description="Reference to the version of a deployed form. If the form is not deployed, this property is null.")
    private Long formVersion;
    @Schema(description="Is the form embedded for this task? If there is no form, this property is null.")
    private Boolean isFormEmbedded;
    @Schema(description="Reference to process definition (renamed equivalent of `Task.processDefinitionId` field).")
    private String processDefinitionKey;
    @Schema(description="Reference to process instance id (renamed equivalent of `Task.processInstanceId` field).")
    private String processInstanceKey;
    @Schema(description="The tenant ID associated with the task.")
    private String tenantId;
    @Schema(description="The due date for the task.")
    private OffsetDateTime dueDate;
    @Schema(description="The follow-up date for the task.")
    private OffsetDateTime followUpDate;
    @ArraySchema(arraySchema=@Schema(description="The candidate groups for the task."))
    private String[] candidateGroups;
    @ArraySchema(arraySchema=@Schema(description="The candidate users for the task."))
    private String[] candidateUsers;
    @ArraySchema(arraySchema=@Schema(description="An array of the task's variables. Only variables specified in `TaskSearchRequest.includeVariables` are returned. Note that a variable's draft value is not returned in `TaskSearchResponse`."))
    @JsonIgnoreProperties(value={"draft"})
    private VariableSearchResponse[] variables;
    @Schema(description="The context variable (from modeler) of the task.")
    private String context;
    private TaskEntity.TaskImplementation implementation;
    @Schema(description="The assigned priority of the task. Only for Zeebe User Tasks.")
    private int priority;

    public String getId() {
        return this.id;
    }

    public TaskSearchResponse setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public TaskSearchResponse setName(String name) {
        this.name = name;
        return this;
    }

    public String getTaskDefinitionId() {
        return this.taskDefinitionId;
    }

    public TaskSearchResponse setTaskDefinitionId(String taskDefinitionId) {
        this.taskDefinitionId = taskDefinitionId;
        return this;
    }

    public String getProcessName() {
        return this.processName;
    }

    public TaskSearchResponse setProcessName(String processName) {
        this.processName = processName;
        return this;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public TaskSearchResponse setCreationDate(String creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    public String getCompletionDate() {
        return this.completionDate;
    }

    public TaskSearchResponse setCompletionDate(String completionDate) {
        this.completionDate = completionDate;
        return this;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public TaskSearchResponse setAssignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    public TaskState getTaskState() {
        return this.taskState;
    }

    public TaskSearchResponse setTaskState(TaskState taskState) {
        this.taskState = taskState;
        return this;
    }

    public String[] getSortValues() {
        return this.sortValues;
    }

    public TaskSearchResponse setSortValues(String[] sortValues) {
        this.sortValues = sortValues;
        return this;
    }

    public boolean getIsFirst() {
        return this.isFirst;
    }

    public TaskSearchResponse setIsFirst(boolean first) {
        this.isFirst = first;
        return this;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public TaskSearchResponse setFormKey(String formKey) {
        this.formKey = formKey;
        return this;
    }

    public String getFormId() {
        return this.formId;
    }

    public TaskSearchResponse setFormId(String formId) {
        this.formId = formId;
        return this;
    }

    public Long getFormVersion() {
        return this.formVersion;
    }

    public TaskSearchResponse setFormVersion(Long formVersion) {
        this.formVersion = formVersion;
        return this;
    }

    public Boolean getIsFormEmbedded() {
        return this.isFormEmbedded;
    }

    public TaskSearchResponse setIsFormEmbedded(Boolean isFormEmbedded) {
        this.isFormEmbedded = isFormEmbedded;
        return this;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public TaskSearchResponse setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    public String getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public TaskSearchResponse setProcessInstanceKey(String processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public TaskSearchResponse setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public OffsetDateTime getDueDate() {
        return this.dueDate;
    }

    public TaskSearchResponse setDueDate(OffsetDateTime dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    public OffsetDateTime getFollowUpDate() {
        return this.followUpDate;
    }

    public TaskSearchResponse setFollowUpDate(OffsetDateTime followUpDate) {
        this.followUpDate = followUpDate;
        return this;
    }

    public String[] getCandidateGroups() {
        return this.candidateGroups;
    }

    public TaskSearchResponse setCandidateGroups(String[] candidateGroups) {
        this.candidateGroups = candidateGroups;
        return this;
    }

    public String[] getCandidateUsers() {
        return this.candidateUsers;
    }

    public TaskSearchResponse setCandidateUsers(String[] candidateUsers) {
        this.candidateUsers = candidateUsers;
        return this;
    }

    public VariableSearchResponse[] getVariables() {
        return this.variables;
    }

    public TaskSearchResponse setVariables(VariableSearchResponse[] variables) {
        this.variables = variables;
        return this;
    }

    public TaskEntity.TaskImplementation getImplementation() {
        return this.implementation;
    }

    public TaskSearchResponse setImplementation(TaskEntity.TaskImplementation implementation) {
        this.implementation = implementation;
        return this;
    }

    public String getContext() {
        return this.context;
    }

    public TaskSearchResponse setContext(String context) {
        this.context = context;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public TaskSearchResponse setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public int hashCode() {
        int result = Objects.hash(this.id, this.name, this.taskDefinitionId, this.processName, this.creationDate, this.completionDate, this.assignee, this.taskState, this.isFirst, this.formKey, this.formId, this.formVersion, this.isFormEmbedded, this.processDefinitionKey, this.processInstanceKey, this.tenantId, this.dueDate, this.followUpDate, this.implementation, this.context, this.priority);
        result = 31 * result + Arrays.hashCode(this.sortValues);
        result = 31 * result + Arrays.hashCode(this.candidateGroups);
        result = 31 * result + Arrays.hashCode(this.candidateUsers);
        result = 31 * result + Arrays.hashCode(this.variables);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskSearchResponse that = (TaskSearchResponse)o;
        return this.isFirst == that.isFirst && this.implementation == that.implementation && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.taskDefinitionId, that.taskDefinitionId) && Objects.equals(this.processName, that.processName) && Objects.equals(this.creationDate, that.creationDate) && Objects.equals(this.completionDate, that.completionDate) && Objects.equals(this.assignee, that.assignee) && Objects.equals(this.context, that.context) && this.taskState == that.taskState && Arrays.equals(this.sortValues, that.sortValues) && Objects.equals(this.formKey, that.formKey) && Objects.equals(this.formId, that.formId) && Objects.equals(this.formVersion, that.formVersion) && Objects.equals(this.isFormEmbedded, that.isFormEmbedded) && Objects.equals(this.processDefinitionKey, that.processDefinitionKey) && Objects.equals(this.processInstanceKey, that.processInstanceKey) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.dueDate, that.dueDate) && Objects.equals(this.followUpDate, that.followUpDate) && this.priority == that.priority && Arrays.equals(this.candidateGroups, that.candidateGroups) && Arrays.equals(this.candidateUsers, that.candidateUsers) && Arrays.equals(this.variables, that.variables);
    }

    public String toString() {
        return new StringJoiner(", ", TaskSearchResponse.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("name='" + this.name + "'").add("taskDefinitionId='" + this.taskDefinitionId + "'").add("processName='" + this.processName + "'").add("creationDate='" + this.creationDate + "'").add("completionDate='" + this.completionDate + "'").add("assignee='" + this.assignee + "'").add("taskState=" + String.valueOf(this.taskState)).add("implementation=" + String.valueOf(this.implementation)).add("sortValues=" + Arrays.toString(this.sortValues)).add("isFirst=" + this.isFirst).add("formKey='" + this.formKey + "'").add("formId='" + this.formId + "'").add("formVersion='" + this.formVersion + "'").add("isFormEmbedded='" + this.isFormEmbedded + "'").add("processDefinitionKey='" + this.processDefinitionKey + "'").add("processInstanceKey='" + this.processInstanceKey + "'").add("tenantId='" + this.tenantId + "'").add("dueDate='" + String.valueOf(this.dueDate) + "'").add("followUpDate='" + String.valueOf(this.followUpDate) + "'").add("candidateGroups=" + Arrays.toString(this.candidateGroups)).add("candidateUsers=" + Arrays.toString(this.candidateUsers)).add("variables=" + Arrays.toString(this.variables)).add("taskContext='" + this.context + "'").add("priority='" + this.priority + "'").toString();
    }
}

