/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.api.rest.v1.entities;

import io.camunda.webapps.schema.entities.ProcessEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.Objects;

public class ProcessResponse {
    @Schema(description="The unique identifier of the process")
    private String id;
    @Schema(description="The name of the process")
    private String name;
    @Schema(description="The BPMN process ID")
    private String bpmnProcessId;
    @Schema(description="Array of values to be copied into `ProcessSearchRequest` to request for next or previous page of processes")
    private String[] sortValues;
    @Schema(description="The version of the process")
    private Integer version;
    @Schema(description="The ID of the form associated with the start event. Null if not set.")
    private String startEventFormId = null;
    @Schema(description="The tenant ID associated with the process")
    private String tenantId;
    @Schema(description="The xml that represents the BPMN for the process")
    private String bpmnXml;

    public String getId() {
        return this.id;
    }

    public ProcessResponse setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ProcessResponse setName(String name) {
        this.name = name;
        return this;
    }

    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    public ProcessResponse setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
        return this;
    }

    public String getStartEventFormId() {
        return this.startEventFormId;
    }

    public ProcessResponse setStartEventFormId(String startEventFormId) {
        this.startEventFormId = startEventFormId;
        return this;
    }

    public String[] getSortValues() {
        return this.sortValues;
    }

    public ProcessResponse setSortValues(String[] sortValues) {
        this.sortValues = sortValues;
        return this;
    }

    public Integer getVersion() {
        return this.version;
    }

    public ProcessResponse setVersion(Integer version) {
        this.version = version;
        return this;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public ProcessResponse setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public String getBpmnXml() {
        return this.bpmnXml;
    }

    public ProcessResponse setBpmnXml(String bpmnXml) {
        this.bpmnXml = bpmnXml;
        return this;
    }

    public static ProcessResponse fromProcessEntity(ProcessEntity process, String startEventFormId) {
        return ProcessResponse.createWithoutBpmnXml(process, startEventFormId).setBpmnXml(process.getBpmnXml());
    }

    public static ProcessResponse fromProcessEntityWithoutBpmnXml(ProcessEntity process, String startEventFormId) {
        return ProcessResponse.createWithoutBpmnXml(process, startEventFormId);
    }

    private static ProcessResponse createWithoutBpmnXml(ProcessEntity process, String startEventFormId) {
        return new ProcessResponse().setId(process.getId()).setName(process.getName()).setBpmnProcessId(process.getBpmnProcessId()).setVersion(process.getVersion()).setStartEventFormId(startEventFormId).setTenantId(process.getTenantId());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.bpmnProcessId, Arrays.hashCode(this.sortValues), this.version, this.startEventFormId, this.tenantId, this.bpmnXml);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessResponse that = (ProcessResponse)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.bpmnProcessId, that.bpmnProcessId) && Objects.deepEquals(this.sortValues, that.sortValues) && Objects.equals(this.version, that.version) && Objects.equals(this.startEventFormId, that.startEventFormId) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.bpmnXml, that.bpmnXml);
    }

    public String toString() {
        return "ProcessResponse{id='" + this.id + "', name='" + this.name + "', bpmnProcessId='" + this.bpmnProcessId + "', sortValues=" + Arrays.toString(this.sortValues) + ", version=" + this.version + ", startEventFormId='" + this.startEventFormId + "', tenantId='" + this.tenantId + "', bpmnXml='" + this.bpmnXml + "'}";
    }
}

