/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.api.rest.v1.controllers;

import io.camunda.tasklist.exceptions.NotFoundException;
import io.camunda.tasklist.store.ProcessStore;
import io.camunda.tasklist.webapp.api.rest.v1.controllers.ApiErrorController;
import io.camunda.webapps.schema.entities.ProcessEntity;
import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@RequestMapping(value={"/tasklist/new/"})
public class PublicProcessController
extends ApiErrorController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublicProcessController.class);
    @Autowired
    private ProcessStore processStore;

    @GetMapping(value={"/{bpmnProcessId}"})
    public ModelAndView index(Model model, @PathVariable String bpmnProcessId, HttpServletRequest req) {
        ModelAndView modelAndView = new ModelAndView("forward:/tasklist/index.html");
        modelAndView.setStatus((HttpStatusCode)HttpStatus.OK);
        try {
            ProcessEntity processEntity = this.processStore.getProcessByBpmnProcessId(bpmnProcessId);
            String title = processEntity.getName() != null ? processEntity.getName() : processEntity.getBpmnProcessId();
            modelAndView.addObject("title", (Object)title);
        }
        catch (NotFoundException ex) {
            LOGGER.warn("Could not find process with id {}", (Object)bpmnProcessId);
            LOGGER.debug("StackTrace:", (Throwable)ex);
        }
        modelAndView.addObject("ogImage", (Object)this.getAbsolutePathOfImage(req));
        modelAndView.addObject("ogUrl", (Object)req.getRequestURL().toString());
        return modelAndView;
    }

    private String getAbsolutePathOfImage(HttpServletRequest request) {
        UriComponentsBuilder builder = UriComponentsBuilder.newInstance().scheme(request.getScheme()).host(request.getServerName()).path(request.getContextPath()).path("/public-start-form-og-image.jpg");
        return builder.toUriString();
    }
}

