/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. See the NOTICE file distributed
 * with this work for additional information regarding copyright ownership.
 * Licensed under the Camunda License 1.0. You may not use this file
 * except in compliance with the Camunda License 1.0.
 */
package io.camunda.tasklist.webapp.security;

import java.util.Optional;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

public final class TasklistAuthenticationUtil {

  private TasklistAuthenticationUtil() {}

  public static boolean isApiUser() {
    return Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication())
        .map(JwtAuthenticationToken.class::isInstance)
        .orElse(false);
  }
}
