/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.service;

import io.camunda.tasklist.entities.TaskEntity;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.webapp.rest.exception.NotFoundApiException;
import io.camunda.tasklist.webapp.security.tenant.TenantService;
import io.camunda.tasklist.webapp.service.TasklistServicesAdapter;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.command.ClientStatusException;
import io.camunda.zeebe.client.api.command.CreateProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import io.camunda.zeebe.gateway.cmd.ClientException;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.grpc.Status;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"standalone"})
public class ZeebeClientBasedAdapter
implements TasklistServicesAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeebeClientBasedAdapter.class);
    private final ZeebeClient zeebeClient;
    private final TenantService tenantService;

    public ZeebeClientBasedAdapter(@Qualifier(value="tasklistZeebeClient") ZeebeClient zeebeClient, TenantService tenantService) {
        this.zeebeClient = zeebeClient;
        this.tenantService = tenantService;
    }

    @Override
    public ProcessInstanceCreationRecord createProcessInstance(String bpmnProcessId, Map<String, Object> variables, String tenantId) {
        return this.doCreateProcessInstance(bpmnProcessId, variables, tenantId);
    }

    @Override
    public ProcessInstanceCreationRecord createProcessInstanceWithoutAuthentication(String bpmnProcessId, Map<String, Object> variables, String tenantId) {
        return this.doCreateProcessInstance(bpmnProcessId, variables, tenantId);
    }

    @Override
    public void assignUserTask(TaskEntity task, String assignee) {
        if (!this.isJobBasedUserTask(task)) {
            try {
                this.zeebeClient.newUserTaskAssignCommand(task.getKey()).assignee(assignee).send().join();
            }
            catch (ClientException exception) {
                throw new TasklistRuntimeException(exception.getMessage());
            }
        }
    }

    @Override
    public void unassignUserTask(TaskEntity task) {
        if (!this.isJobBasedUserTask(task)) {
            try {
                this.zeebeClient.newUserTaskUnassignCommand(task.getKey()).send().join();
            }
            catch (ClientException exception) {
                throw new TasklistRuntimeException(exception.getMessage());
            }
        }
    }

    @Override
    public void completeUserTask(TaskEntity task, Map<String, Object> variables) {
        try {
            if (this.isJobBasedUserTask(task)) {
                this.zeebeClient.newCompleteCommand(task.getKey()).variables(variables).send().join();
            } else {
                this.zeebeClient.newUserTaskCompleteCommand(task.getKey()).variables(variables).send().join();
            }
        }
        catch (ClientException exception) {
            throw new TasklistRuntimeException(exception.getMessage());
        }
    }

    private ProcessInstanceCreationRecord doCreateProcessInstance(String bpmnProcessId, Map<String, Object> variables, String tenantId) {
        CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 createProcessInstanceCommandStep3 = this.zeebeClient.newCreateInstanceCommand().bpmnProcessId(bpmnProcessId).latestVersion();
        if (this.tenantService.isMultiTenancyEnabled()) {
            createProcessInstanceCommandStep3.tenantId(tenantId);
        }
        if (variables != null && !variables.isEmpty()) {
            createProcessInstanceCommandStep3.variables(variables);
        }
        ProcessInstanceEvent processInstanceEvent = null;
        try {
            processInstanceEvent = (ProcessInstanceEvent)createProcessInstanceCommandStep3.send().join();
            LOGGER.debug("Process instance created for process [{}]", (Object)bpmnProcessId);
        }
        catch (ClientStatusException ex) {
            if (Status.Code.NOT_FOUND.equals((Object)ex.getStatusCode())) {
                throw new NotFoundApiException(String.format("No process definition found with processDefinitionKey: '%s'", bpmnProcessId), ex);
            }
            throw new TasklistRuntimeException(ex.getMessage(), (Throwable)ex);
        }
        catch (ClientException ex) {
            throw new TasklistRuntimeException(ex.getMessage(), (Throwable)ex);
        }
        return new ProcessInstanceCreationRecord().setProcessInstanceKey(processInstanceEvent.getProcessInstanceKey());
    }
}

