/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.entities.DraftTaskVariableEntity;
import io.camunda.tasklist.entities.FlowNodeInstanceEntity;
import io.camunda.tasklist.entities.TaskEntity;
import io.camunda.tasklist.entities.TaskState;
import io.camunda.tasklist.entities.TaskVariableEntity;
import io.camunda.tasklist.entities.VariableEntity;
import io.camunda.tasklist.exceptions.NotFoundException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.store.DraftVariableStore;
import io.camunda.tasklist.store.TaskStore;
import io.camunda.tasklist.store.VariableStore;
import io.camunda.tasklist.webapp.api.rest.v1.entities.VariableResponse;
import io.camunda.tasklist.webapp.api.rest.v1.entities.VariableSearchResponse;
import io.camunda.tasklist.webapp.es.TaskValidator;
import io.camunda.tasklist.webapp.graphql.entity.VariableDTO;
import io.camunda.tasklist.webapp.graphql.entity.VariableInputDTO;
import io.camunda.tasklist.webapp.rest.exception.InvalidRequestException;
import io.camunda.tasklist.webapp.rest.exception.NotFoundApiException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class VariableService {
    private static final Logger LOGGER = LoggerFactory.getLogger(VariableService.class);
    private static final String ABSENT_PARENT_ID = "-1";
    @Autowired
    private TaskStore taskStore;
    @Autowired
    private VariableStore variableStore;
    @Autowired
    private DraftVariableStore draftVariableStore;
    @Autowired
    private TasklistProperties tasklistProperties;
    @Autowired
    private TaskValidator taskValidator;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;

    public void persistDraftTaskVariables(String taskId, List<VariableInputDTO> draftTaskVariables) {
        try {
            TaskEntity task = this.taskStore.getTask(taskId);
            this.taskValidator.validateCanPersistDraftTaskVariables(task);
            this.validateVariableInputs(draftTaskVariables);
            long deletedDraftVariablesCount = this.draftVariableStore.deleteAllByTaskId(taskId);
            LOGGER.debug("'{}' draft task variables associated with task id '{}' were deleted", (Object)deletedDraftVariablesCount, (Object)task);
            if (CollectionUtils.isEmpty(draftTaskVariables)) {
                return;
            }
            HashMap currentOriginalVariables = new HashMap();
            this.getRuntimeVariablesByRequest(VariableStore.GetVariablesRequest.createFrom((TaskEntity)task)).forEach(originalVar -> currentOriginalVariables.put(originalVar.getName(), originalVar));
            int variableSizeThreshold = this.tasklistProperties.getImporter().getVariableSizeThreshold();
            HashMap toPersist = new HashMap();
            draftTaskVariables.forEach(draftVariable -> {
                if (currentOriginalVariables.containsKey(draftVariable.getName())) {
                    VariableEntity variableEntity = (VariableEntity)currentOriginalVariables.get(draftVariable.getName());
                    if (!variableEntity.getFullValue().equals(draftVariable.getValue())) {
                        toPersist.put(draftVariable.getName(), DraftTaskVariableEntity.createFrom((String)variableEntity.getId(), (TaskEntity)task, (String)draftVariable.getName(), (String)draftVariable.getValue(), (int)variableSizeThreshold));
                    }
                } else {
                    toPersist.put(draftVariable.getName(), DraftTaskVariableEntity.createFrom((TaskEntity)task, (String)draftVariable.getName(), (String)draftVariable.getValue(), (int)variableSizeThreshold));
                }
            });
            this.draftVariableStore.createOrUpdate(toPersist.values());
        }
        catch (NotFoundException e) {
            throw new NotFoundApiException("Task not found", e);
        }
    }

    private void validateVariableInputs(Collection<VariableInputDTO> variable) {
        variable.stream().map(VariableInputDTO::getValue).forEach(value -> {
            try {
                this.objectMapper.readValue(value, Object.class);
            }
            catch (IOException e) {
                throw new InvalidRequestException(e.getMessage(), e);
            }
        });
    }

    public void persistTaskVariables(String taskId, List<VariableInputDTO> changedVariables, boolean withDraftVariableValues, String processInstanceKey) {
        TaskEntity task = this.taskStore.getTask(taskId);
        String taskFlowNodeInstanceId = task.getFlowNodeInstanceId();
        List<VariableEntity> taskVariables = this.getRuntimeVariablesByRequest(VariableStore.GetVariablesRequest.createFrom((TaskEntity)task));
        HashMap<String, TaskVariableEntity> finalVariablesMap = new HashMap<String, TaskVariableEntity>();
        taskVariables.forEach(variable -> finalVariablesMap.put(variable.getName(), TaskVariableEntity.createFrom((String)taskId, (VariableEntity)variable, (String)processInstanceKey)));
        if (withDraftVariableValues) {
            this.draftVariableStore.getVariablesByTaskIdAndVariableNames(taskId, Collections.emptyList()).forEach(draftTaskVariable -> finalVariablesMap.put(draftTaskVariable.getName(), TaskVariableEntity.createFrom((String)taskId, (DraftTaskVariableEntity)draftTaskVariable, (String)task.getProcessInstanceId())));
        }
        for (VariableInputDTO var : changedVariables) {
            finalVariablesMap.put(var.getName(), TaskVariableEntity.createFrom((String)task.getTenantId(), (String)taskId, (String)var.getName(), (String)var.getValue(), (int)this.tasklistProperties.getImporter().getVariableSizeThreshold(), (String)task.getProcessInstanceId()));
        }
        this.variableStore.persistTaskVariables(finalVariablesMap.values());
    }

    public void deleteDraftTaskVariables(String taskId) {
        this.draftVariableStore.deleteAllByTaskId(taskId);
    }

    private List<VariableEntity> getRuntimeVariablesByRequest(VariableStore.GetVariablesRequest getVariablesRequest) {
        List<VariableStore.GetVariablesRequest> requests = Collections.singletonList(getVariablesRequest);
        Map<String, List<VariableEntity>> runtimeVariablesPerTaskId = this.getRuntimeVariablesPerTaskId(requests);
        if (runtimeVariablesPerTaskId.size() > 0) {
            return runtimeVariablesPerTaskId.values().iterator().next();
        }
        return new ArrayList<VariableEntity>();
    }

    private List<VariableEntity> getRuntimeVariablesDTOPerTaskId(List<VariableStore.GetVariablesRequest> requests) {
        Map<String, List<VariableEntity>> variablesByTaskIds = this.getRuntimeVariablesPerTaskId(requests);
        if (variablesByTaskIds.size() > 0) {
            return variablesByTaskIds.values().iterator().next();
        }
        return new ArrayList<VariableEntity>();
    }

    private Map<String, List<VariableEntity>> getRuntimeVariablesPerTaskId(List<VariableStore.GetVariablesRequest> requests) {
        if (requests == null || requests.size() == 0) {
            return new HashMap<String, List<VariableEntity>>();
        }
        Map<String, VariableStore.FlowNodeTree> flowNodeTrees = this.buildFlowNodeTrees(requests);
        List<String> flowNodeInstanceIds = flowNodeTrees.values().stream().flatMap(f -> f.getFlowNodeInstanceIds().stream()).collect(Collectors.toList());
        Map<String, VariableStore.VariableMap> variableMaps = this.buildVariableMaps(flowNodeInstanceIds, requests.stream().map(VariableStore.GetVariablesRequest::getVarNames).filter(Objects::nonNull).flatMap(Collection::stream).distinct().collect(Collectors.toList()), requests.get(0).getFieldNames());
        return this.buildResponse(flowNodeTrees, variableMaps, requests);
    }

    private Map<String, List<VariableEntity>> buildResponse(Map<String, VariableStore.FlowNodeTree> flowNodeTrees, Map<String, VariableStore.VariableMap> variableMaps, List<VariableStore.GetVariablesRequest> requests) {
        HashMap<String, List<VariableEntity>> response = new HashMap<String, List<VariableEntity>>();
        for (VariableStore.GetVariablesRequest req : requests) {
            VariableStore.FlowNodeTree flowNodeTree = flowNodeTrees.get(req.getProcessInstanceId());
            VariableStore.VariableMap resultingVariableMap = new VariableStore.VariableMap();
            this.accumulateVariables(resultingVariableMap, variableMaps, flowNodeTree, req.getFlowNodeInstanceId());
            response.put(req.getTaskId(), resultingVariableMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> (VariableEntity)e.getValue()).collect(Collectors.toList()));
        }
        return response;
    }

    @NotNull
    private Collector<Map.Entry<String, VariableEntity>, ArrayList<VariableDTO>, ArrayList<VariableDTO>> getVariableDTOListCollector() {
        return Collector.of(ArrayList::new, (list, entry) -> list.add(VariableDTO.createFrom((VariableEntity)entry.getValue())), (list1, list2) -> {
            list1.addAll(list2);
            return list1;
        }, new Collector.Characteristics[0]);
    }

    private void accumulateVariables(VariableStore.VariableMap resultingVariableMap, Map<String, VariableStore.VariableMap> variableMaps, VariableStore.FlowNodeTree flowNodeTree, String flowNodeInstanceId) {
        String parentFlowNodeId;
        VariableStore.VariableMap m = variableMaps.get(flowNodeInstanceId);
        if (m != null) {
            resultingVariableMap.putAll(m);
        }
        String string = parentFlowNodeId = flowNodeTree != null ? flowNodeTree.getParent(flowNodeInstanceId) : null;
        if (parentFlowNodeId != null && !parentFlowNodeId.equals(ABSENT_PARENT_ID)) {
            this.accumulateVariables(resultingVariableMap, variableMaps, flowNodeTree, parentFlowNodeId);
        }
    }

    private Map<String, VariableStore.VariableMap> buildVariableMaps(List<String> flowNodeInstanceIds, List<String> varNames, Set<String> fieldNames) {
        List variables = this.variableStore.getVariablesByFlowNodeInstanceIds(flowNodeInstanceIds, varNames, fieldNames);
        return variables.stream().collect(Collectors.groupingBy(VariableEntity::getScopeFlowNodeId, this.getVariableMapCollector()));
    }

    @NotNull
    private Collector<VariableEntity, VariableStore.VariableMap, VariableStore.VariableMap> getVariableMapCollector() {
        return Collector.of(VariableStore.VariableMap::new, (map, var) -> map.put((Object)var.getName(), var), (map1, map2) -> {
            map1.putAll(map2);
            return map1;
        }, new Collector.Characteristics[0]);
    }

    private Map<String, VariableStore.FlowNodeTree> buildFlowNodeTrees(List<VariableStore.GetVariablesRequest> requests) {
        List processInstanceIds = requests.stream().map(VariableStore.GetVariablesRequest::getProcessInstanceId).distinct().collect(Collectors.toList());
        List flowNodeInstances = this.variableStore.getFlowNodeInstances(processInstanceIds);
        HashMap<String, VariableStore.FlowNodeTree> flowNodeTrees = new HashMap<String, VariableStore.FlowNodeTree>();
        for (FlowNodeInstanceEntity flowNodeInstance : flowNodeInstances) {
            this.getFlowNodeTree(flowNodeTrees, flowNodeInstance.getProcessInstanceId()).setParent(flowNodeInstance.getId(), flowNodeInstance.getParentFlowNodeId());
        }
        return flowNodeTrees;
    }

    private VariableStore.FlowNodeTree getFlowNodeTree(Map<String, VariableStore.FlowNodeTree> flowNodeTrees, String processInstanceId) {
        return flowNodeTrees.computeIfAbsent(processInstanceId, pi -> new VariableStore.FlowNodeTree());
    }

    public List<VariableSearchResponse> getVariableSearchResponses(String taskId, Set<String> variableNames) {
        TaskEntity task = this.taskStore.getTask(taskId);
        List<VariableStore.GetVariablesRequest> requests = Collections.singletonList(VariableStore.GetVariablesRequest.createFrom((TaskEntity)task).setVarNames(new ArrayList<String>(variableNames)).setFieldNames(Collections.emptySet()));
        ArrayList<VariableSearchResponse> vars = new ArrayList<VariableSearchResponse>();
        switch (task.getState()) {
            case CREATED: {
                HashMap<String, VariableEntity> nameToOriginalVariables = new HashMap<String, VariableEntity>();
                this.getRuntimeVariablesDTOPerTaskId(requests).forEach(originalVar -> nameToOriginalVariables.put(originalVar.getName(), (VariableEntity)originalVar));
                HashMap nameToDraftVariable = new HashMap();
                this.draftVariableStore.getVariablesByTaskIdAndVariableNames(taskId, new ArrayList<String>(variableNames)).forEach(draftVar -> nameToDraftVariable.put(draftVar.getName(), draftVar));
                nameToOriginalVariables.forEach((name, originalVar) -> {
                    if (nameToDraftVariable.containsKey(name)) {
                        vars.add(VariableSearchResponse.createFrom(originalVar, (DraftTaskVariableEntity)nameToDraftVariable.get(name)));
                    } else {
                        vars.add(VariableSearchResponse.createFrom(originalVar));
                    }
                });
                CollectionUtils.removeAll(nameToDraftVariable.keySet(), nameToOriginalVariables.keySet()).forEach(draftVariableName -> vars.add(VariableSearchResponse.createFrom((DraftTaskVariableEntity)nameToDraftVariable.get(draftVariableName))));
                break;
            }
            case COMPLETED: {
                Map variablesByTaskIds = this.variableStore.getTaskVariablesPerTaskId(requests);
                if (variablesByTaskIds.size() <= 0) break;
                vars.addAll(((List)variablesByTaskIds.values().iterator().next()).stream().map(VariableSearchResponse::createFrom).toList());
                break;
            }
        }
        return vars.stream().sorted(Comparator.comparing(VariableSearchResponse::getName)).toList();
    }

    public List<VariableDTO> getVariables(String taskId, List<String> variableNames, Set<String> fieldNames) {
        TaskEntity task = this.taskStore.getTask(taskId);
        List<VariableStore.GetVariablesRequest> requests = Collections.singletonList(VariableStore.GetVariablesRequest.createFrom((TaskEntity)task).setVarNames(variableNames).setFieldNames(fieldNames));
        ArrayList<VariableDTO> vars = new ArrayList<VariableDTO>();
        switch (task.getState()) {
            case CREATED: {
                vars.addAll(VariableDTO.createFrom(this.getRuntimeVariablesDTOPerTaskId(requests)));
                break;
            }
            case COMPLETED: {
                Map variablesByTaskIds = this.variableStore.getTaskVariablesPerTaskId(requests);
                if (variablesByTaskIds.size() <= 0) break;
                vars.addAll(((List)variablesByTaskIds.values().iterator().next()).stream().map(VariableDTO::createFrom).toList());
                break;
            }
        }
        vars.sort(Comparator.comparing(VariableDTO::getName));
        return vars;
    }

    public List<List<VariableDTO>> getVariables(List<VariableStore.GetVariablesRequest> requests) {
        Map<String, List<VariableDTO>> variablesPerTaskId = this.getVariablesPerTaskId(requests);
        ArrayList<List<VariableDTO>> result = new ArrayList<List<VariableDTO>>();
        for (VariableStore.GetVariablesRequest req : requests) {
            result.add(variablesPerTaskId.getOrDefault(req.getTaskId(), Collections.emptyList()).stream().sorted(Comparator.comparing(VariableDTO::getName)).toList());
        }
        return result;
    }

    public Map<String, List<VariableDTO>> getVariablesPerTaskId(List<VariableStore.GetVariablesRequest> requests) {
        HashMap<String, List<VariableDTO>> result = new HashMap<String, List<VariableDTO>>();
        Map<TaskState, List<VariableStore.GetVariablesRequest>> groupByStates = requests.stream().collect(Collectors.groupingBy(VariableStore.GetVariablesRequest::getState));
        if (groupByStates.containsKey(TaskState.CREATED)) {
            result.putAll(this.getRuntimeVariablesPerTaskId(groupByStates.get(TaskState.CREATED)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> VariableDTO.createFrom((List)e.getValue()))));
        }
        if (groupByStates.containsKey(TaskState.COMPLETED)) {
            result.putAll(this.variableStore.getTaskVariablesPerTaskId(groupByStates.get(TaskState.COMPLETED)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> VariableDTO.createFromTaskVariables((List)e.getValue()))));
        }
        return result;
    }

    public VariableDTO getVariable(String variableId, Set<String> fieldNames) {
        try {
            VariableEntity runtimeVariable = this.variableStore.getRuntimeVariable(variableId, fieldNames);
            return VariableDTO.createFrom(runtimeVariable);
        }
        catch (NotFoundException ex) {
            try {
                TaskVariableEntity taskVariable = this.variableStore.getTaskVariable(variableId, fieldNames);
                return VariableDTO.createFrom(taskVariable);
            }
            catch (NotFoundException ex2) {
                throw new NotFoundApiException(String.format("Variable with id %s not found.", variableId));
            }
        }
    }

    public VariableResponse getVariableResponse(String variableId) {
        try {
            VariableEntity runtimeVariable = this.variableStore.getRuntimeVariable(variableId, Collections.emptySet());
            VariableResponse variableResponse = VariableResponse.createFrom(runtimeVariable);
            this.draftVariableStore.getById(variableId).ifPresent(variableResponse::addDraft);
            return variableResponse;
        }
        catch (NotFoundException ex) {
            return this.draftVariableStore.getById(variableId).map(VariableResponse::createFrom).orElseGet(() -> {
                try {
                    TaskVariableEntity taskVariable = this.variableStore.getTaskVariable(variableId, Collections.emptySet());
                    return VariableResponse.createFrom(taskVariable);
                }
                catch (NotFoundException ex2) {
                    throw new NotFoundApiException(String.format("Variable with id %s not found.", variableId));
                }
            });
        }
    }
}

