/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security.sso;

import com.auth0.client.auth.AuthAPI;
import com.auth0.exception.Auth0Exception;
import com.auth0.json.auth.TokenHolder;
import com.auth0.jwt.JWT;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.net.TokenRequest;
import io.camunda.tasklist.webapp.security.OldUsernameAware;
import io.camunda.tasklist.webapp.security.Permission;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.Scope;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.stereotype.Component;

@Profile(value={"sso-auth"})
@Component
@Scope(value="prototype")
public class TokenAuthentication
extends AbstractAuthenticationToken
implements OldUsernameAware {
    public static final String ORGANIZATION_ID = "id";
    public static final String ROLES_KEY = "roles";
    private transient Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${camunda.tasklist.auth0.claimName}")
    private String claimName;
    @Value(value="${camunda.tasklist.auth0.organization}")
    private String organization;
    @Value(value="${camunda.tasklist.auth0.domain}")
    private String domain;
    @Value(value="${camunda.tasklist.auth0.clientId}")
    private String clientId;
    @Value(value="${camunda.tasklist.auth0.clientSecret}")
    private String clientSecret;
    private String idToken;
    private String refreshToken;
    private String accessToken;
    private String salesPlanType;
    private List<Permission> permissions = new ArrayList<Permission>();

    public TokenAuthentication() {
        super(null);
    }

    private boolean isIdEqualsOrganization(Map<String, String> orgs) {
        return orgs.containsKey(ORGANIZATION_ID) && orgs.get(ORGANIZATION_ID).equals(this.organization);
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(this.getClass());
        }
        return this.logger;
    }

    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public void addPermission(Permission permission) {
        this.permissions.add(permission);
    }

    public boolean isAuthenticated() {
        if (this.hasExpired()) {
            this.getLogger().info("Tokens are expired");
            if (this.refreshToken == null) {
                this.setAuthenticated(false);
                this.getLogger().info("No refresh token available. Authentication is invalid.");
            } else {
                this.getLogger().info("Get a new tokens by using refresh token");
                this.getNewTokenByRefreshToken();
            }
        }
        return super.isAuthenticated();
    }

    public String getNewTokenByRefreshToken() {
        try {
            TokenRequest tokenRequest = this.getAuthAPI().renewAuth(this.refreshToken);
            TokenHolder tokenHolder = (TokenHolder)tokenRequest.execute();
            this.authenticate(tokenHolder.getIdToken(), tokenHolder.getRefreshToken(), tokenHolder.getAccessToken());
            this.getLogger().info("New tokens received and validated.");
            return this.accessToken;
        }
        catch (Auth0Exception e) {
            this.getLogger().error(e.getMessage(), e.getCause());
            this.setAuthenticated(false);
            return null;
        }
    }

    private AuthAPI getAuthAPI() {
        return new AuthAPI(this.domain, this.clientId, this.clientSecret);
    }

    public boolean hasExpired() {
        Date expires = this.getExpiresAt();
        return expires == null || expires.before(new Date());
    }

    public Date getExpiresAt() {
        return JWT.decode((String)this.idToken).getExpiresAt();
    }

    public String getCredentials() {
        return JWT.decode((String)this.idToken).getToken();
    }

    public Object getPrincipal() {
        return JWT.decode((String)this.idToken).getSubject();
    }

    public void authenticate(String idToken, String refreshToken, String accessToken) {
        this.idToken = idToken;
        this.accessToken = accessToken;
        if (refreshToken != null) {
            this.refreshToken = refreshToken;
        }
        Claim claim = JWT.decode((String)idToken).getClaim(this.claimName);
        this.tryAuthenticateAsListOfMaps(claim);
        if (!this.isAuthenticated()) {
            throw new InsufficientAuthenticationException("No permission for tasklist - check your organization id");
        }
    }

    private void tryAuthenticateAsListOfMaps(Claim claim) {
        try {
            List claims = claim.asList(Map.class);
            if (claims != null) {
                this.setAuthenticated(claims.stream().anyMatch(this::isIdEqualsOrganization));
            }
        }
        catch (JWTDecodeException e) {
            this.getLogger().debug("Read organization claim as list of maps failed.", (Throwable)e);
        }
    }

    public Map<String, Claim> getClaims() {
        return JWT.decode((String)this.idToken).getClaims();
    }

    public List<String> getRoles(String organizationsKey) {
        try {
            Map<String, Claim> claims = this.getClaims();
            return this.findRolesForOrganization(claims, organizationsKey, this.organization);
        }
        catch (Exception e) {
            this.getLogger().error("Could not get roles. Return empty roles list.", (Throwable)e);
            return List.of();
        }
    }

    private List<String> findRolesForOrganization(Map<String, Claim> claims, String organizationsKey, String organization) {
        try {
            Optional<Map> orgInfo;
            List orgInfos = claims.get(organizationsKey).asList(Map.class);
            if (orgInfos != null && (orgInfo = orgInfos.stream().filter(oi -> oi.get(ORGANIZATION_ID).equals(organization)).findFirst()).isPresent()) {
                return (List)orgInfo.get().get(ROLES_KEY);
            }
        }
        catch (Exception e) {
            this.getLogger().error(String.format("Couldn't extract roles for organization '%s' in JWT claims. Return empty roles list.", organization), (Throwable)e);
        }
        return List.of();
    }

    public String getSalesPlanType() {
        return this.salesPlanType;
    }

    public void setSalesPlanType(String salesPlanType) {
        this.salesPlanType = salesPlanType;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getOrganization() {
        return this.organization;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TokenAuthentication that = (TokenAuthentication)o;
        return this.claimName.equals(that.claimName) && this.organization.equals(that.organization) && this.domain.equals(that.domain) && this.clientId.equals(that.clientId) && this.clientSecret.equals(that.clientSecret) && this.idToken.equals(that.idToken) && Objects.equals(this.refreshToken, that.refreshToken) && Objects.equals(this.salesPlanType, that.salesPlanType);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.claimName, this.organization, this.domain, this.clientId, this.clientSecret, this.idToken, this.refreshToken, this.salesPlanType);
    }

    @Override
    public String getOldName() {
        return this.getName();
    }
}

