/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security.identity;

import io.camunda.tasklist.webapp.security.Permission;
import org.springframework.core.convert.converter.Converter;

public final class PermissionConverter
implements Converter<String, Permission> {
    public static final String READ_PERMISSION_VALUE = "read:*";
    public static final String WRITE_PERMISSION_VALUE = "write:*";
    private static volatile PermissionConverter instance;
    private static Object lock;

    private PermissionConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PermissionConverter getInstance() {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new PermissionConverter();
                }
            }
        }
        return instance;
    }

    public Permission convert(String source) {
        if (source.equals(READ_PERMISSION_VALUE)) {
            return Permission.READ;
        }
        if (source.equals(WRITE_PERMISSION_VALUE)) {
            return Permission.WRITE;
        }
        return null;
    }

    static {
        lock = new Object();
    }
}

