/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security.identity;

import io.camunda.identity.sdk.Identity;
import io.camunda.identity.sdk.authentication.AccessToken;
import io.camunda.identity.sdk.authentication.Tokens;
import io.camunda.identity.sdk.authentication.UserDetails;
import io.camunda.identity.sdk.authentication.exception.TokenDecodeException;
import io.camunda.identity.sdk.exception.InvalidConfigurationException;
import io.camunda.identity.sdk.impl.rest.exception.RestException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.util.SpringContextHolder;
import io.camunda.tasklist.webapp.security.OldUsernameAware;
import io.camunda.tasklist.webapp.security.Permission;
import io.camunda.tasklist.webapp.security.identity.IdentityAuthorization;
import io.camunda.tasklist.webapp.security.identity.IdentityService;
import io.camunda.tasklist.webapp.security.identity.PermissionConverter;
import io.camunda.tasklist.webapp.security.tenant.TasklistTenant;
import io.camunda.tasklist.webapp.security.tenant.TenantAwareAuthentication;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class IdentityAuthentication
extends AbstractAuthenticationToken
implements OldUsernameAware,
TenantAwareAuthentication {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentityAuthentication.class);
    private Tokens tokens;
    private String id;
    private String name;
    private String userDisplayName;
    private List<String> permissions;
    private String subject;
    private Date expires;
    private Date refreshTokenExpiresAt;
    private volatile List<TasklistTenant> tenants = Collections.emptyList();
    private IdentityAuthorization authorization;
    private List<String> groups;

    public IdentityAuthentication() {
        super(null);
    }

    public String getCredentials() {
        return this.tokens.getAccessToken();
    }

    public Object getPrincipal() {
        return this.subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TasklistTenant> getTenants() {
        if (CollectionUtils.isEmpty(this.tenants)) {
            IdentityAuthentication identityAuthentication = this;
            synchronized (identityAuthentication) {
                if (CollectionUtils.isEmpty(this.tenants)) {
                    this.retrieveTenants();
                }
            }
        }
        return this.tenants;
    }

    private void retrieveTenants() {
        block5: {
            if (IdentityAuthentication.getTasklistProperties().getMultiTenancy().isEnabled()) {
                try {
                    String accessToken = this.tokens.getAccessToken();
                    List identityTenants = this.getIdentity().tenants().forToken(accessToken);
                    if (CollectionUtils.isNotEmpty((Collection)identityTenants)) {
                        this.tenants = identityTenants.stream().map(t -> new TasklistTenant(t.getTenantId(), t.getName())).sorted(TENANT_NAMES_COMPARATOR).toList();
                        break block5;
                    }
                    this.tenants = List.of();
                }
                catch (RestException ex) {
                    LOGGER.warn("Unable to retrieve tenants from Identity. Error: " + ex.getMessage(), (Throwable)ex);
                    this.tenants = List.of();
                }
            } else {
                this.tenants = List.of();
            }
        }
    }

    public Tokens getTokens() {
        return this.tokens;
    }

    private boolean hasExpired() {
        return this.expires == null || this.expires.before(new Date());
    }

    private boolean hasRefreshTokenExpired() {
        try {
            LOGGER.info("Refresh token will expire at {}", (Object)this.refreshTokenExpiresAt);
            return this.refreshTokenExpiresAt == null || this.refreshTokenExpiresAt.before(new Date());
        }
        catch (TokenDecodeException e) {
            LOGGER.info("Refresh token is not a JWT and expire date can not be determined. Error message: {}", (Object)e.getMessage());
            return false;
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isAuthenticated() {
        if (this.hasExpired()) {
            LOGGER.info("Access token is expired");
            if (this.hasRefreshTokenExpired()) {
                LOGGER.info("No refresh token available. Authentication is invalid.");
                this.setAuthenticated(false);
                this.getIdentity().authentication().revokeToken(this.tokens.getRefreshToken());
                return false;
            }
            try {
                LOGGER.info("Get a new access token by using refresh token");
                this.renewAccessToken();
            }
            catch (Exception e) {
                LOGGER.error("Renewing access token failed with exception", (Throwable)e);
                this.setAuthenticated(false);
            }
        }
        return super.isAuthenticated();
    }

    public String getId() {
        return this.id;
    }

    public List<Permission> getPermissions() {
        return this.permissions.stream().map(PermissionConverter.getInstance()::convert).collect(Collectors.toList());
    }

    public void authenticate(Tokens tokens) {
        if (tokens != null) {
            this.tokens = tokens;
        }
        AccessToken accessToken = this.getIdentity().authentication().verifyToken(this.tokens.getAccessToken());
        UserDetails userDetails = accessToken.getUserDetails();
        this.id = userDetails.getId();
        this.name = this.retrieveName(userDetails);
        this.userDisplayName = this.retrieveUserDisplayName();
        this.permissions = accessToken.getPermissions();
        if (!this.getPermissions().contains((Object)Permission.READ)) {
            throw new InsufficientAuthenticationException("No read permissions");
        }
        try {
            TasklistProperties props = IdentityAuthentication.getTasklistProperties();
            if (props.getIdentity().isResourcePermissionsEnabled()) {
                this.authorization = new IdentityAuthorization(this.getIdentity().authorizations().forToken(this.tokens.getAccessToken()));
            }
        }
        catch (InvalidConfigurationException ice) {
            LOGGER.debug("Base URL is not provided so it's not possible to get authorizations from Identity");
        }
        catch (Exception e) {
            LOGGER.debug("Identity and Tasklist misconfiguration.");
        }
        this.subject = accessToken.getToken().getSubject();
        this.expires = accessToken.getToken().getExpiresAt();
        this.groups = accessToken.getUserDetails().getGroups();
        if (!this.isPolling()) {
            try {
                this.refreshTokenExpiresAt = this.getIdentity().authentication().decodeJWT(this.tokens.getRefreshToken()).getExpiresAt();
            }
            catch (TokenDecodeException e) {
                LOGGER.error("Unable to decode refresh token {} with exception: {}", (Object)this.tokens.getRefreshToken(), (Object)e.getMessage());
            }
        }
        if (!this.hasExpired()) {
            this.setAuthenticated(true);
        } else {
            this.setAuthenticated(false);
        }
    }

    @NotNull
    private static TasklistProperties getTasklistProperties() {
        return (TasklistProperties)SpringContextHolder.getBean(TasklistProperties.class);
    }

    private String retrieveName(UserDetails userDetails) {
        return userDetails.getUsername().orElse(userDetails.getId());
    }

    private void renewAccessToken() {
        this.authenticate(this.renewTokens(this.tokens.getRefreshToken()));
    }

    private Tokens renewTokens(String refreshToken) {
        return (Tokens)IdentityService.requestWithRetry(() -> this.getIdentity().authentication().renewToken(refreshToken));
    }

    private Identity getIdentity() {
        return (Identity)SpringContextHolder.getBean(Identity.class);
    }

    public IdentityAuthentication setExpires(Date expires) {
        this.expires = expires;
        return this;
    }

    public IdentityAuthentication setPermissions(List<String> permissions) {
        this.permissions = permissions;
        return this;
    }

    public String getUserDisplayName() {
        return this.userDisplayName;
    }

    private String retrieveUserDisplayName() {
        return this.getIdentity().authentication().verifyToken(this.tokens.getAccessToken()).getUserDetails().getName().orElse(this.name);
    }

    public IdentityAuthentication setUserDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
        return this;
    }

    @Override
    public String getOldName() {
        return this.getId();
    }

    public IdentityAuthorization getAuthorizations() {
        return this.authorization;
    }

    public IdentityAuthentication setAuthorizations(IdentityAuthorization authorization) {
        this.authorization = authorization;
        return this;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public IdentityAuthentication setGroups(List<String> groups) {
        this.groups = groups;
        return this;
    }

    private boolean isPolling() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            return RequestContextHolder.getRequestAttributes() != null && Boolean.TRUE.equals(Boolean.parseBoolean(((ServletRequestAttributes)requestAttributes).getRequest().getHeader("x-is-polling")));
        }
        return false;
    }
}

