/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.graphql.scalar;

import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.GraphQLScalarType;
import io.camunda.tasklist.util.DateUtil;
import java.text.ParseException;
import java.util.Date;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DateScalarConfiguration {
    @Bean
    public GraphQLScalarType javaUtilDateScalar() {
        return GraphQLScalarType.newScalar().name("javaUtilDate").description("java.util.Date scalar compliant with RFC 3339 profile of the ISO 8601 standard").coercing((Coercing)new Coercing<Date, String>(this){

            public String serialize(Object dataFetcherResult) {
                if (dataFetcherResult instanceof Date) {
                    return DateUtil.SIMPLE_DATE_FORMAT.format((Date)dataFetcherResult);
                }
                throw new CoercingParseLiteralException("Cannot serialize " + String.valueOf(dataFetcherResult));
            }

            public Date parseValue(Object input) {
                try {
                    return DateUtil.SIMPLE_DATE_FORMAT.parse(String.valueOf(input));
                }
                catch (ParseException e) {
                    throw new CoercingParseLiteralException("Cannot parse " + String.valueOf(input) + " as DateTime", (Throwable)e);
                }
            }

            public Date parseLiteral(Object input) {
                try {
                    if (!(input instanceof StringValue)) {
                        throw new CoercingParseLiteralException("String value expected for: " + String.valueOf(input));
                    }
                    return DateUtil.SIMPLE_DATE_FORMAT.parse(((StringValue)input).getValue());
                }
                catch (ParseException e) {
                    throw new CoercingParseLiteralException("Cannot parse " + String.valueOf(input) + " as DateTime", (Throwable)e);
                }
            }
        }).build();
    }
}

