/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.es.backup;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.client.json.JsonData;

public class Metadata {
    public static final String SNAPSHOT_NAME_PREFIX = "camunda_tasklist_";
    private static final String SNAPSHOT_NAME_PATTERN = "{prefix}{version}_part_{index}_of_{count}";
    private static final String SNAPSHOT_NAME_PREFIX_PATTERN = "camunda_tasklist_{backupId}_";
    private static final Pattern BACKUPID_PATTERN = Pattern.compile("camunda_tasklist_(\\d*)_.*");
    private static final Pattern METADATA_PATTERN = Pattern.compile("camunda_tasklist_(?<backupId>\\d+)_(?<version>[^_]+)_part_(?<index>\\d+)_of_(?<count>\\d+)");
    private Long backupId;
    private String version;
    private Integer partNo;
    private Integer partCount;

    public Metadata() {
    }

    public Metadata(Metadata metadata) {
        this.backupId = metadata.backupId;
        this.version = metadata.version;
        this.partNo = metadata.partNo;
        this.partCount = metadata.partCount;
    }

    public Long getBackupId() {
        return this.backupId;
    }

    public Metadata setBackupId(Long backupId) {
        this.backupId = backupId;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public Metadata setVersion(String version) {
        this.version = version;
        return this;
    }

    public Integer getPartNo() {
        return this.partNo;
    }

    public Metadata setPartNo(Integer partNo) {
        this.partNo = partNo;
        return this;
    }

    public Integer getPartCount() {
        return this.partCount;
    }

    public Metadata setPartCount(Integer partCount) {
        this.partCount = partCount;
        return this;
    }

    public String buildSnapshotName() {
        return SNAPSHOT_NAME_PATTERN.replace("{prefix}", Metadata.buildSnapshotNamePrefix(this.backupId)).replace("{version}", this.version).replace("{index}", "" + this.partNo).replace("{count}", "" + this.partCount);
    }

    public boolean checkIsInitialized() {
        return this.partCount != null && this.partNo != null && this.version != null;
    }

    public static String buildSnapshotNamePrefix(Long backupId) {
        return SNAPSHOT_NAME_PREFIX_PATTERN.replace("{backupId}", String.valueOf(backupId));
    }

    public static Long extractBackupIdFromSnapshotName(String snapshotName) {
        Matcher matcher = BACKUPID_PATTERN.matcher(snapshotName);
        if (matcher.matches()) {
            return Long.valueOf(matcher.group(1));
        }
        throw new TasklistRuntimeException("Unable to extract backupId. Snapshot name: " + snapshotName);
    }

    public static Metadata extractMetadataFromSnapshotName(String snapshotName) {
        Objects.requireNonNull(snapshotName, "Snapshot name cannot be null");
        Matcher matcher = METADATA_PATTERN.matcher(snapshotName);
        if (matcher.matches()) {
            Long backupId = Long.parseLong(matcher.group("backupId"));
            String version = matcher.group("version");
            Integer index = Integer.parseInt(matcher.group("index"));
            Integer count = Integer.parseInt(matcher.group("count"));
            return new Metadata().setBackupId(backupId).setPartCount(count).setPartNo(index).setVersion(version);
        }
        throw new IllegalArgumentException("Unable to extract metadata. Snapshot name: " + snapshotName);
    }

    public static Metadata fromObjectMapper(ObjectMapper objectMapper, Map<String, Object> jsonMap) {
        if (jsonMap == null) {
            return null;
        }
        return (Metadata)objectMapper.convertValue(jsonMap, Metadata.class);
    }

    public static Metadata fromOSJsonData(Map<String, JsonData> jsonDataMap) {
        if (jsonDataMap == null) {
            return null;
        }
        try {
            return new Metadata().setBackupId((Long)jsonDataMap.get("backupId").to(Long.class)).setPartCount((Integer)jsonDataMap.get("partCount").to(Integer.class)).setPartNo((Integer)jsonDataMap.get("partNo").to(Integer.class)).setVersion((String)jsonDataMap.get("version").to(String.class));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Metadata extractFromMetadataOrName(Metadata fromMetadata, String snapshotName) {
        if (fromMetadata != null && fromMetadata.checkIsInitialized()) {
            return fromMetadata;
        }
        return Metadata.extractMetadataFromSnapshotName(snapshotName);
    }

    public int hashCode() {
        return Objects.hash(this.backupId, this.version, this.partNo, this.partCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata metadata = (Metadata)o;
        return Objects.equals(this.backupId, metadata.backupId) && Objects.equals(this.version, metadata.version) && Objects.equals(this.partNo, metadata.partNo) && Objects.equals(this.partCount, metadata.partCount);
    }
}

