/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.api.rest.v1.entities;

import io.camunda.tasklist.entities.ProcessEntity;
import io.camunda.tasklist.webapp.graphql.entity.ProcessDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public class ProcessPublicEndpointsResponse {
    @Schema(description="The BPMN process ID")
    private String bpmnProcessId;
    @Schema(description="The process definition key")
    private String processDefinitionKey;
    @Schema(description="The endpoint associated with the process")
    private String endpoint;
    @Schema(description="The tenant ID associated with the process")
    private String tenantId;

    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    public ProcessPublicEndpointsResponse setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
        return this;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public ProcessPublicEndpointsResponse setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public ProcessPublicEndpointsResponse setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public static ProcessPublicEndpointsResponse fromProcessDTO(ProcessDTO process) {
        return new ProcessPublicEndpointsResponse().setBpmnProcessId(process.getProcessDefinitionId()).setProcessDefinitionKey(process.getId()).setEndpoint(String.format("/tasklist/new/".concat("%s"), process.getProcessDefinitionId()));
    }

    public static ProcessPublicEndpointsResponse fromProcessEntity(ProcessEntity process) {
        return new ProcessPublicEndpointsResponse().setBpmnProcessId(process.getBpmnProcessId()).setProcessDefinitionKey(process.getId()).setEndpoint(String.format("/tasklist/new/".concat("%s"), process.getBpmnProcessId())).setTenantId(process.getTenantId());
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public ProcessPublicEndpointsResponse setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessPublicEndpointsResponse that = (ProcessPublicEndpointsResponse)o;
        return Objects.equals(this.bpmnProcessId, that.bpmnProcessId) && Objects.equals(this.processDefinitionKey, that.processDefinitionKey) && Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.tenantId, that.tenantId);
    }

    public int hashCode() {
        return Objects.hash(this.bpmnProcessId, this.processDefinitionKey, this.endpoint, this.tenantId);
    }

    public String toString() {
        return "ProcessPublicEndpointsResponse{bpmnProcessId='" + this.bpmnProcessId + "', processDefinitionKey='" + this.processDefinitionKey + "', endpoint='" + this.endpoint + "', tenantId='" + this.tenantId + "'}";
    }
}

