/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security.se;

import io.camunda.authentication.entity.CamundaUser;
import io.camunda.tasklist.util.CollectionUtil;
import io.camunda.tasklist.webapp.graphql.entity.UserDTO;
import io.camunda.tasklist.webapp.security.UserReader;
import io.camunda.tasklist.webapp.security.se.Role;
import io.camunda.tasklist.webapp.security.se.RolePermissionService;
import io.camunda.tasklist.webapp.security.se.store.UserStore;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"!sso-auth & !identity-auth"})
public class SearchEngineUserReader
implements UserReader {
    @Autowired
    private UserStore userStore;
    @Autowired
    private RolePermissionService rolePermissionService;

    @Override
    public Optional<UserDTO> getCurrentUserBy(Authentication authentication) {
        Object principal = authentication.getPrincipal();
        if (principal instanceof CamundaUser) {
            CamundaUser user = (CamundaUser)principal;
            return Optional.of(new UserDTO().setUserId(user.getUserId()).setDisplayName(user.getDisplayName()).setPermissions(this.rolePermissionService.getPermissions(user.getRoles().stream().map(Role::fromString).toList())).setApiUser(false));
        }
        return Optional.empty();
    }

    @Override
    public String getCurrentOrganizationId() {
        return "null";
    }

    @Override
    public List<UserDTO> getUsersByUsernames(List<String> userIds) {
        return CollectionUtil.map(this.userStore.getUsersByUserIds(userIds), userEntity -> new UserDTO().setUserId(userEntity.getUserId()).setDisplayName(userEntity.getDisplayName()).setApiUser(false));
    }

    @Override
    public Optional<String> getUserToken(Authentication authentication) {
        throw new UnsupportedOperationException("Get token is not supported for Identity authentication");
    }
}

