/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security.se;

import io.camunda.authentication.entity.CamundaUser;
import io.camunda.tasklist.entities.UserEntity;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.webapp.rest.exception.NotFoundApiException;
import io.camunda.tasklist.webapp.security.se.Role;
import io.camunda.tasklist.webapp.security.se.store.UserStore;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

@Configuration
@Component
@Profile(value={"!sso-auth & !identity-auth & !auth-basic"})
@Primary
public class SearchEngineUserDetailsService
implements UserDetailsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchEngineUserDetailsService.class);
    @Autowired
    private UserStore userStore;
    @Autowired
    private TasklistProperties tasklistProperties;

    @Bean
    @Primary
    public PasswordEncoder getPasswordEncoder() {
        return new BCryptPasswordEncoder();
    }

    public void initializeUsers() {
        boolean createSchema;
        boolean bl = createSchema = "elasticsearch".equalsIgnoreCase(this.tasklistProperties.getDatabase()) ? this.tasklistProperties.getElasticsearch().isCreateSchema() : this.tasklistProperties.getOpenSearch().isCreateSchema();
        if (createSchema) {
            String userId = this.tasklistProperties.getUserId();
            String displayName = this.tasklistProperties.getDisplayName();
            String password = this.tasklistProperties.getPassword();
            String readerUserId = this.tasklistProperties.getReaderUserId();
            String readerDisplayName = this.tasklistProperties.getReaderDisplayName();
            String readerPassword = this.tasklistProperties.getReaderPassword();
            String operatorUserId = this.tasklistProperties.getOperatorUserId();
            String operatorDisplayName = this.tasklistProperties.getOperatorDisplayName();
            String operatorPassword = this.tasklistProperties.getOperatorPassword();
            List roles = this.tasklistProperties.getRoles();
            if (!this.userExists(userId)) {
                this.addUserWith(userId, displayName, password, roles);
            }
            if (!this.userExists(readerUserId)) {
                this.addUserWith(readerUserId, readerDisplayName, readerPassword, List.of(Role.READER.name()));
            }
            if (!this.userExists(operatorUserId)) {
                this.addUserWith(operatorUserId, operatorDisplayName, operatorPassword, List.of(Role.OPERATOR.name()));
            }
        }
    }

    private boolean userExists(String userId) {
        try {
            return this.userStore.getByUserId(userId) != null;
        }
        catch (Exception t) {
            return false;
        }
    }

    SearchEngineUserDetailsService addUserWith(String userId, String displayName, String password, List<String> roles) {
        LOGGER.info("Create user with userId {}", (Object)userId);
        String passwordEncoded = this.getPasswordEncoder().encode((CharSequence)password);
        UserEntity userEntity = ((UserEntity)new UserEntity().setId(userId)).setUserId(userId).setDisplayName(displayName).setPassword(passwordEncoded).setRoles(roles);
        this.userStore.create(userEntity);
        return this;
    }

    public CamundaUser loadUserByUsername(String username) throws UsernameNotFoundException {
        try {
            UserEntity userEntity = this.userStore.getByUserId(username);
            return new CamundaUser(userEntity.getDisplayName(), userEntity.getUserId(), userEntity.getPassword(), userEntity.getRoles());
        }
        catch (NotFoundApiException e) {
            throw new UsernameNotFoundException(String.format("User with user id '%s' not found.", username), (Throwable)e);
        }
    }
}

