/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security.identity;

import io.camunda.identity.sdk.authorizations.dto.Authorization;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class IdentityAuthorization
implements Serializable {
    public static final String PROCESS_PERMISSION_START = "START_PROCESS_INSTANCE";
    public static final String PROCESS_PERMISSION_READ = "READ";
    private static final String PROCESS_DEFINITION = "process-definition";
    private List<String> processesAllowedToStart = new ArrayList<String>();
    private final List<String> processesAllowedToRead = new ArrayList<String>();

    public IdentityAuthorization(List<Authorization> authorizations) {
        for (Authorization authorization : authorizations) {
            if (!authorization.getResourceType().equals(PROCESS_DEFINITION)) continue;
            this.addPermissions(authorization, this.processesAllowedToStart, PROCESS_PERMISSION_START);
            this.addPermissions(authorization, this.processesAllowedToRead, PROCESS_PERMISSION_READ);
        }
    }

    private void addPermissions(Authorization authorization, List<String> processesAllowed, String expectedPermission) {
        if (!processesAllowed.contains("*") && authorization.getPermissions().contains(expectedPermission)) {
            if (authorization.getResourceKey().equals("*")) {
                processesAllowed.clear();
                processesAllowed.add("*");
            } else {
                processesAllowed.add(authorization.getResourceKey());
            }
        }
    }

    public List<String> getProcessesAllowedToStart() {
        return this.processesAllowedToStart;
    }

    public IdentityAuthorization setProcessesAllowedToStart(List<String> processesAllowedToStart) {
        this.processesAllowedToStart = processesAllowedToStart;
        return this;
    }

    public List<String> getProcessesAllowedToRead() {
        return this.processesAllowedToRead;
    }
}

