/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security;

import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.webapp.security.AssigneeMigrator;
import io.camunda.tasklist.webapp.security.OldUsernameAware;
import io.camunda.webapps.schema.descriptors.tasklist.index.TasklistMetricIndex;
import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class AssigneeMigratorElasticSearch
implements AssigneeMigrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AssigneeMigratorElasticSearch.class);
    @Autowired
    @Qualifier(value="tasklistEsClient")
    private RestHighLevelClient esClient;
    @Autowired
    private TasklistMetricIndex metricIndex;
    @Autowired
    private TasklistProperties tasklistProperties;

    @Override
    public void migrateUsageMetrics(String newAssignee) {
        if (!this.tasklistProperties.isFixUsernames()) {
            LOGGER.debug("Migration of usernames is disabled.");
            return;
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (!(authentication instanceof OldUsernameAware)) {
            LOGGER.debug("No migration of usernames possible.");
            return;
        }
        OldUsernameAware oldUsernameAware = (OldUsernameAware)authentication;
        String oldAssignee = oldUsernameAware.getOldName();
        LOGGER.debug("Migrate old assignee {} to new assignee {}", (Object)oldAssignee, (Object)newAssignee);
        TermsQueryBuilder oldAssigneeQuery = QueryBuilders.termsQuery((String)"value", (String[])new String[]{oldAssignee});
        Script updateScript = new Script(ScriptType.INLINE, "painless", "ctx._source.value = '" + newAssignee + "'", Collections.emptyMap());
        long migrated = this.updateByQuery(this.metricIndex.getFullQualifiedName(), (QueryBuilder)oldAssigneeQuery, updateScript);
        if (migrated > 0L) {
            LOGGER.info("Migrated {} usage metric entries from old assignee {} to new assignee {}.", new Object[]{migrated, oldAssignee, newAssignee});
        }
    }

    public long updateByQuery(String indexPattern, QueryBuilder query, Script updateScript) {
        try {
            UpdateByQueryRequest request = (UpdateByQueryRequest)new UpdateByQueryRequest(new String[]{indexPattern}).setQuery(query).setScript(updateScript);
            BulkByScrollResponse response = this.esClient.updateByQuery(request, RequestOptions.DEFAULT);
            return response.getTotal();
        }
        catch (IOException e) {
            throw new TasklistRuntimeException("Error while trying to update entities for query " + String.valueOf(query));
        }
    }
}

