/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.management;

import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.webapp.es.backup.BackupManager;
import io.camunda.tasklist.webapp.management.ManagementAPIErrorController;
import io.camunda.tasklist.webapp.rest.exception.InvalidRequestException;
import io.camunda.tasklist.webapp.rest.exception.NotFoundApiException;
import io.camunda.webapps.backup.GetBackupStateResponseDto;
import io.camunda.webapps.backup.TakeBackupRequestDto;
import io.camunda.webapps.backup.TakeBackupResponseDto;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Component
@RestControllerEndpoint(id="backups")
@Profile(value={"standalone"})
public class BackupService
extends ManagementAPIErrorController {
    @Autowired
    private BackupManager backupManager;
    @Autowired
    private TasklistProperties tasklistProperties;
    private final Pattern pattern = Pattern.compile("((?![A-Z \"*\\\\<|,>\\/?_]).){0,3996}$");

    @PostMapping(produces={"application/json"})
    public TakeBackupResponseDto takeBackup(@RequestBody TakeBackupRequestDto request) {
        this.validateRequest(request);
        this.validateRepositoryNameIsConfigured();
        return this.backupManager.takeBackup(request);
    }

    private void validateRepositoryNameIsConfigured() {
        if (this.tasklistProperties.getBackup() == null || StringUtils.isBlank((CharSequence)this.tasklistProperties.getBackup().getRepositoryName())) {
            throw new NotFoundApiException("No backup repository configured.");
        }
    }

    @GetMapping(value={"/{backupId}"})
    public GetBackupStateResponseDto getBackupState(@PathVariable Long backupId) {
        this.validateBackupId(backupId);
        this.validateRepositoryNameIsConfigured();
        return this.backupManager.getBackupState(backupId);
    }

    @GetMapping
    public List<GetBackupStateResponseDto> getBackups() {
        this.validateRepositoryNameIsConfigured();
        return this.backupManager.getBackups();
    }

    @DeleteMapping(value={"/{backupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteBackup(@PathVariable Long backupId) {
        this.validateBackupId(backupId);
        this.validateRepositoryNameIsConfigured();
        this.backupManager.deleteBackup(backupId);
    }

    private void validateRequest(TakeBackupRequestDto request) {
        if (request.getBackupId() == null) {
            throw new InvalidRequestException("BackupId must be provided");
        }
        this.validateBackupId(request.getBackupId());
    }

    private void validateBackupId(Long backupId) {
        if (backupId < 0L) {
            throw new InvalidRequestException("BackupId must be a non-negative Long. Received value: " + backupId);
        }
    }
}

