/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.graphql;

import graphql.kickstart.execution.context.DefaultGraphQLContext;
import graphql.kickstart.execution.context.GraphQLKickstartContext;
import graphql.kickstart.servlet.context.GraphQLServletContextBuilder;
import io.camunda.tasklist.webapp.security.UserReader;
import io.camunda.tasklist.webapp.service.VariableService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.websocket.Session;
import jakarta.websocket.server.HandshakeRequest;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.dataloader.DataLoaderFactory;
import org.dataloader.DataLoaderRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TasklistGraphQLContextBuilder
implements GraphQLServletContextBuilder {
    public static final String USER_DATA_LOADER = "userDataLoader";
    public static final String VARIABLE_DATA_LOADER = "variableDataLoader";
    @Autowired
    private UserReader userReader;
    @Autowired
    private VariableService variableService;

    public GraphQLKickstartContext build(HttpServletRequest req, HttpServletResponse response) {
        return GraphQLKickstartContext.of((DataLoaderRegistry)this.buildDataLoaderRegistry(), Map.of(HttpServletRequest.class, req, HttpServletResponse.class, response));
    }

    public GraphQLKickstartContext build(Session session, HandshakeRequest request) {
        return GraphQLKickstartContext.of((DataLoaderRegistry)this.buildDataLoaderRegistry(), Map.of(Session.class, session, HandshakeRequest.class, request));
    }

    public GraphQLKickstartContext build() {
        return new DefaultGraphQLContext(this.buildDataLoaderRegistry());
    }

    private DataLoaderRegistry buildDataLoaderRegistry() {
        return new DataLoaderRegistry().register(USER_DATA_LOADER, DataLoaderFactory.newDataLoader(usernames -> CompletableFuture.supplyAsync(() -> this.userReader.getUsersByUsernames(usernames)))).register(VARIABLE_DATA_LOADER, DataLoaderFactory.newDataLoader(req -> CompletableFuture.supplyAsync(() -> this.variableService.getVariables(req))));
    }
}

