/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.api.rest.v1.entities;

import io.camunda.webapps.schema.entities.tasklist.TaskEntity;
import io.camunda.webapps.schema.entities.tasklist.TaskState;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;

public class TaskResponse {
    @Schema(description="The unique identifier of the task.")
    private String id;
    @Schema(description="The name of the task.")
    private String name;
    @Schema(description="User Task ID from the BPMN definition.")
    private String taskDefinitionId;
    @Schema(description="The name of the process.")
    private String processName;
    @Schema(description="When was the task created (renamed equivalent of `Task.creationTime` field).")
    private String creationDate;
    @Schema(description="When was the task completed (renamed equivalent of `Task.completionTime` field).")
    private String completionDate;
    @Schema(description="The username/id of who is assigned to the task.")
    private String assignee;
    @Schema(description="The state of the task.", accessMode=Schema.AccessMode.READ_ONLY)
    private TaskState taskState;
    @Schema(description="Reference to the task form.")
    private String formKey;
    @Schema(description="Reference to the ID of a deployed form. If the form is not deployed, this property is null.")
    private String formId;
    @Schema(description="Reference to the version of a deployed form. If the form is not deployed, this property is null.", format="int64")
    private Long formVersion;
    @Schema(description="Is the form embedded for this task? If there is no form, this property is null.")
    private Boolean isFormEmbedded;
    @Schema(description="Reference to process definition (renamed equivalent of `Task.processDefinitionId` field).")
    private String processDefinitionKey;
    @Schema(description="Reference to process instance id (renamed equivalent of `Task.processInstanceId` field).")
    private String processInstanceKey;
    @Schema(description="The tenant ID associated with the task.")
    private String tenantId;
    @Schema(description="The due date for the task.", format="date-time")
    private OffsetDateTime dueDate;
    @Schema(description="The follow-up date for the task.", format="date-time")
    private OffsetDateTime followUpDate;
    @ArraySchema(arraySchema=@Schema(description="The candidate groups for the task."))
    private String[] candidateGroups;
    @ArraySchema(arraySchema=@Schema(description="The candidate users for the task."))
    private String[] candidateUsers;
    private TaskEntity.TaskImplementation implementation;
    @Schema(description="The assigned priority of the task. Only for Zeebe User Tasks.")
    private int priority;

    public String getId() {
        return this.id;
    }

    public TaskResponse setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public TaskResponse setName(String name) {
        this.name = name;
        return this;
    }

    public String getTaskDefinitionId() {
        return this.taskDefinitionId;
    }

    public TaskResponse setTaskDefinitionId(String taskDefinitionId) {
        this.taskDefinitionId = taskDefinitionId;
        return this;
    }

    public String getProcessName() {
        return this.processName;
    }

    public TaskResponse setProcessName(String processName) {
        this.processName = processName;
        return this;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public TaskResponse setCreationDate(String creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    public String getCompletionDate() {
        return this.completionDate;
    }

    public TaskResponse setCompletionDate(String completionDate) {
        this.completionDate = completionDate;
        return this;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public TaskResponse setAssignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    public TaskState getTaskState() {
        return this.taskState;
    }

    public TaskResponse setTaskState(TaskState taskState) {
        this.taskState = taskState;
        return this;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public TaskResponse setFormKey(String formKey) {
        this.formKey = formKey;
        return this;
    }

    public String getFormId() {
        return this.formId;
    }

    public TaskResponse setFormId(String formId) {
        this.formId = formId;
        return this;
    }

    public Long getFormVersion() {
        return this.formVersion;
    }

    public TaskResponse setFormVersion(Long formVersion) {
        this.formVersion = formVersion;
        return this;
    }

    public Boolean getIsFormEmbedded() {
        return this.isFormEmbedded;
    }

    public TaskResponse setIsFormEmbedded(Boolean isFormEmbedded) {
        this.isFormEmbedded = isFormEmbedded;
        return this;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public TaskResponse setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    public String getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public TaskResponse setProcessInstanceKey(String processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public TaskResponse setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public OffsetDateTime getDueDate() {
        return this.dueDate;
    }

    public TaskResponse setDueDate(OffsetDateTime dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    public OffsetDateTime getFollowUpDate() {
        return this.followUpDate;
    }

    public TaskResponse setFollowUpDate(OffsetDateTime followUpDate) {
        this.followUpDate = followUpDate;
        return this;
    }

    public String[] getCandidateGroups() {
        return this.candidateGroups;
    }

    public TaskResponse setCandidateGroups(String[] candidateGroups) {
        this.candidateGroups = candidateGroups;
        return this;
    }

    public String[] getCandidateUsers() {
        return this.candidateUsers;
    }

    public TaskResponse setCandidateUsers(String[] candidateUsers) {
        this.candidateUsers = candidateUsers;
        return this;
    }

    public TaskEntity.TaskImplementation getImplementation() {
        return this.implementation;
    }

    public TaskResponse setImplementation(TaskEntity.TaskImplementation implementation) {
        this.implementation = implementation;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public TaskResponse setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public int hashCode() {
        int result = Objects.hash(this.id, this.name, this.taskDefinitionId, this.processName, this.creationDate, this.completionDate, this.assignee, this.taskState, this.formKey, this.formId, this.formVersion, this.isFormEmbedded, this.processDefinitionKey, this.processInstanceKey, this.tenantId, this.dueDate, this.followUpDate, this.priority);
        result = 31 * result + Arrays.hashCode(this.candidateGroups);
        result = 31 * result + Arrays.hashCode(this.candidateUsers);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskResponse that = (TaskResponse)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.taskDefinitionId, that.taskDefinitionId) && Objects.equals(this.processName, that.processName) && Objects.equals(this.creationDate, that.creationDate) && Objects.equals(this.completionDate, that.completionDate) && Objects.equals(this.assignee, that.assignee) && this.taskState == that.taskState && Objects.equals(this.formKey, that.formKey) && Objects.equals(this.formId, that.formId) && Objects.equals(this.formVersion, that.formVersion) && Objects.equals(this.isFormEmbedded, that.isFormEmbedded) && Objects.equals(this.processDefinitionKey, that.processDefinitionKey) && Objects.equals(this.processInstanceKey, that.processInstanceKey) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.dueDate, that.dueDate) && Objects.equals(this.followUpDate, that.followUpDate) && this.priority == that.priority && Arrays.equals(this.candidateGroups, that.candidateGroups) && Arrays.equals(this.candidateUsers, that.candidateUsers);
    }

    public String toString() {
        return new StringJoiner(", ", TaskResponse.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("name='" + this.name + "'").add("taskDefinitionId='" + this.taskDefinitionId + "'").add("processName='" + this.processName + "'").add("creationDate='" + this.creationDate + "'").add("completionDate='" + this.completionDate + "'").add("assignee='" + this.assignee + "'").add("taskState=" + String.valueOf(this.taskState)).add("formKey='" + this.formKey + "'").add("formId='" + this.formId + "'").add("formId='" + this.formVersion + "'").add("isFormEmbedded='" + this.isFormEmbedded + "'").add("processDefinitionKey='" + this.processDefinitionKey + "'").add("processInstanceKey='" + this.processInstanceKey + "'").add("tenantId='" + this.tenantId + "'").add("dueDate='" + String.valueOf(this.dueDate) + "'").add("followUpDate='" + String.valueOf(this.followUpDate) + "'").add("candidateGroups=" + Arrays.toString(this.candidateGroups)).add("candidateUsers=" + Arrays.toString(this.candidateUsers)).add("priority=" + this.priority).toString();
    }
}

