/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.api.rest.v1.controllers.internal;

import io.camunda.tasklist.entities.ProcessEntity;
import io.camunda.tasklist.exceptions.NotFoundException;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.store.FormStore;
import io.camunda.tasklist.store.ProcessInstanceStore;
import io.camunda.tasklist.store.ProcessStore;
import io.camunda.tasklist.webapp.api.rest.v1.controllers.ApiErrorController;
import io.camunda.tasklist.webapp.api.rest.v1.entities.ProcessPublicEndpointsResponse;
import io.camunda.tasklist.webapp.api.rest.v1.entities.ProcessResponse;
import io.camunda.tasklist.webapp.api.rest.v1.entities.StartProcessRequest;
import io.camunda.tasklist.webapp.graphql.entity.ProcessInstanceDTO;
import io.camunda.tasklist.webapp.graphql.entity.VariableInputDTO;
import io.camunda.tasklist.webapp.rest.exception.Error;
import io.camunda.tasklist.webapp.rest.exception.InvalidRequestException;
import io.camunda.tasklist.webapp.rest.exception.NotFoundApiException;
import io.camunda.tasklist.webapp.security.identity.IdentityAuthorizationService;
import io.camunda.tasklist.webapp.security.tenant.TenantService;
import io.camunda.tasklist.webapp.service.ProcessService;
import io.camunda.webapps.schema.entities.tasklist.FormEntity;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Process", description="API to manage processes.")
@RestController
@RequestMapping(value={"/v1/internal/processes"}, produces={"application/json"})
public class ProcessInternalController
extends ApiErrorController {
    @Autowired
    private ProcessStore processStore;
    @Autowired
    private FormStore formStore;
    @Autowired
    private ProcessService processService;
    @Autowired
    private ProcessInstanceStore processInstanceStore;
    @Autowired
    private TasklistProperties tasklistProperties;
    @Autowired
    private IdentityAuthorizationService identityAuthorizationService;
    @Autowired
    private TenantService tenantService;

    @Operation(summary="Returns the process by ProcessDefinitionKey", description="Returns the process by ProcessDefinitionKey", responses={@ApiResponse(description="On success returned", responseCode="200", useReturnTypeSchema=true), @ApiResponse(description="Forbidden - User without privileges to read process", responseCode="403"), @ApiResponse(description="Process Not Found", responseCode="404")})
    @GetMapping(value={"{processDefinitionKey}"})
    public ResponseEntity<ProcessResponse> getProcess(@PathVariable String processDefinitionKey) {
        ProcessEntity processEntity = this.processService.getProcessByProcessDefinitionKeyAndAccessRestriction(processDefinitionKey);
        new ProcessResponse();
        ProcessResponse processResponse = ProcessResponse.fromProcessEntity(processEntity, this.getStartEventFormIdByBpmnProcess(processEntity));
        return ResponseEntity.ok((Object)processResponse);
    }

    @Operation(summary="Returns the list of processes by search query", description="Get the processes by `search` query.", responses={@ApiResponse(description="On success returned", responseCode="200", useReturnTypeSchema=true)})
    @GetMapping
    public ResponseEntity<List<ProcessResponse>> searchProcesses(@Parameter(description="Used to search processes by processId, process name, and process definition id fields.") @RequestParam(defaultValue="") String query, @Parameter(description="Identifies the tenant.<br>If multi-tenancy is enabled and `tenantId` is not provided, processes for all tenants available for the current user will be returned.<br>If `tenantId` is provided, only processes for that tenant will be returned, or an empty list if the user does not have access to the provided tenant.<br>If multi-tenancy is disabled, this parameter will be ignored.") @RequestParam(required=false) String tenantId, @Parameter(description="If this parameter is set (Default value `null`): <br>`true`: It will return all the processes started by a form <br>`false`: It will return all the processes that are not started by a form <br>`null`: The filter is not applied") @RequestParam(required=false) Boolean isStartedByForm) {
        List processes = this.processStore.getProcesses(query, this.identityAuthorizationService.getProcessDefinitionsFromAuthorization(), tenantId, isStartedByForm).stream().map(pe -> ProcessResponse.fromProcessEntityWithoutBpmnXml(pe, this.getStartEventFormIdByBpmnProcess((ProcessEntity)pe))).collect(Collectors.toList());
        return ResponseEntity.ok(processes);
    }

    private String getStartEventFormIdByBpmnProcess(ProcessEntity process) {
        if (process.getIsFormEmbedded() != null && !process.getIsFormEmbedded().booleanValue()) {
            if (process.getFormId() != null) {
                try {
                    FormEntity form = this.formStore.getForm(process.getFormId(), process.getId(), null);
                    return form.getFormId();
                }
                catch (NotFoundException e) {
                    return process.getFormId();
                }
            }
        } else if (process.getFormKey() != null) {
            String formId = StringUtils.substringAfterLast((String)process.getFormKey(), (String)":");
            FormEntity form = this.formStore.getForm(formId, process.getId(), null);
            return form.getFormId();
        }
        return null;
    }

    @Operation(summary="Start process by bpmnProcessId and tenantId when multi-tenancy is active", description="Start process by `bpmnProcessId` and `tenantId` when multi-tenancy is active.", responses={@ApiResponse(description="On success returned", responseCode="200", useReturnTypeSchema=true), @ApiResponse(description="An error is returned when invalid or missing `tenantId` provided when multi-tenancy is active.", responseCode="400", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))}), @ApiResponse(description="An error is returned when the process is not found by `bpmnProcessId`.", responseCode="404", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))})})
    @PreAuthorize(value="hasPermission('write')")
    @PatchMapping(value={"{bpmnProcessId}/start"})
    public ResponseEntity<ProcessInstanceDTO> startProcessInstance(@PathVariable String bpmnProcessId, @Parameter(description="Required for multi-tenancy setups to ensure the process starts for the intended tenant. In environments without multi-tenancy, this parameter is not considered.") @RequestParam(required=false) String tenantId, @RequestBody(required=false) StartProcessRequest startProcessRequest) {
        List<VariableInputDTO> variables = Objects.requireNonNullElse(startProcessRequest, new StartProcessRequest()).getVariables();
        ProcessInstanceDTO processInstance = this.processService.startProcessInstance(bpmnProcessId, variables, tenantId);
        return ResponseEntity.ok((Object)processInstance);
    }

    @Operation(summary="Delete process instance by given processInstanceId.", description="Delete process instance by given `processInstanceId`.", responses={@ApiResponse(description="On success returned", responseCode="204", useReturnTypeSchema=true), @ApiResponse(description="An error is returned when the `processInstance` with `processInstanceId` is not found`.", responseCode="404", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))}), @ApiResponse(description="An error is returned when the `processInstance` with `processInstanceId` could not be deleted`.", responseCode="500", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))})})
    @PreAuthorize(value="hasPermission('write')")
    @DeleteMapping(value={"{processInstanceId}"})
    public ResponseEntity<?> deleteProcessInstance(@PathVariable String processInstanceId) {
        switch (this.processInstanceStore.deleteProcessInstance(processInstanceId)) {
            case DELETED: {
                break;
            }
            case NOT_FOUND: {
                throw new NotFoundApiException(String.format("The process with processInstanceId: '%s' is not found", processInstanceId));
            }
            default: {
                throw new TasklistRuntimeException(String.format("The deletion of process with processInstanceId: '%s' could not be deleted", processInstanceId));
            }
        }
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Return all the public endpoints to start a process by a form.", description="Return all the public endpoints to start a process by a form.", responses={@ApiResponse(description="On success returned", responseCode="200", useReturnTypeSchema=true)})
    @GetMapping(value={"publicEndpoints"})
    public ResponseEntity<List<ProcessPublicEndpointsResponse>> getPublicEndpoints() {
        List publicEndpoints = this.tasklistProperties.getFeatureFlag().getProcessPublicEndpoints() != false ? this.processStore.getProcessesStartedByForm().stream().map(ProcessPublicEndpointsResponse::fromProcessEntity).collect(Collectors.toList()) : Collections.emptyList();
        return ResponseEntity.ok(publicEndpoints);
    }

    @Operation(summary="Fetch public endpoint to initiate process via a form.", description="Provides a public endpoint for starting a process using a form, based on the given `processDefinitionKey`. Ensure the correct `tenantId` is provided in multi-tenancy setups.", responses={@ApiResponse(description="On success returned", responseCode="200", useReturnTypeSchema=true), @ApiResponse(description="An error is returned when invalid or missing `tenantId` provided when multi-tenancy is active.", responseCode="400", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))}), @ApiResponse(description="An error is returned when the public endpoint is not found by `processDefinitionKey`.", responseCode="404", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))})})
    @GetMapping(value={"{bpmnProcessId}/publicEndpoint"})
    public ResponseEntity<ProcessPublicEndpointsResponse> getPublicEndpoint(@PathVariable String bpmnProcessId, @Parameter(description="If using multi-tenancy, this parameter ensures the system fetches the public endpoint for the correct tenant. In environments without multi-tenancy, this parameter is not considered.") @RequestParam(required=false) String tenantId) {
        if (!this.tenantService.isTenantValid(tenantId)) {
            throw new InvalidRequestException("Invalid Tenant");
        }
        ProcessEntity process = this.processStore.getProcessByBpmnProcessId(bpmnProcessId, tenantId);
        if (!process.isStartedByForm()) {
            throw new NotFoundApiException(String.format("The public endpoint for bpmnProcessId: '%s' is not found", bpmnProcessId));
        }
        return ResponseEntity.ok((Object)ProcessPublicEndpointsResponse.fromProcessEntity(process));
    }
}

