/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.api.rest.v1.controllers;

import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.queries.TaskByCandidateUserOrGroup;
import io.camunda.tasklist.util.LazySupplier;
import io.camunda.tasklist.webapp.api.rest.v1.controllers.ApiErrorController;
import io.camunda.tasklist.webapp.api.rest.v1.entities.IncludeVariable;
import io.camunda.tasklist.webapp.api.rest.v1.entities.SaveVariablesRequest;
import io.camunda.tasklist.webapp.api.rest.v1.entities.TaskAssignRequest;
import io.camunda.tasklist.webapp.api.rest.v1.entities.TaskCompleteRequest;
import io.camunda.tasklist.webapp.api.rest.v1.entities.TaskResponse;
import io.camunda.tasklist.webapp.api.rest.v1.entities.TaskSearchRequest;
import io.camunda.tasklist.webapp.api.rest.v1.entities.TaskSearchResponse;
import io.camunda.tasklist.webapp.api.rest.v1.entities.VariableSearchResponse;
import io.camunda.tasklist.webapp.api.rest.v1.entities.VariablesSearchRequest;
import io.camunda.tasklist.webapp.graphql.entity.TaskDTO;
import io.camunda.tasklist.webapp.graphql.entity.TaskQueryDTO;
import io.camunda.tasklist.webapp.graphql.entity.VariableInputDTO;
import io.camunda.tasklist.webapp.mapper.TaskMapper;
import io.camunda.tasklist.webapp.rest.exception.Error;
import io.camunda.tasklist.webapp.rest.exception.ForbiddenActionException;
import io.camunda.tasklist.webapp.rest.exception.InvalidRequestException;
import io.camunda.tasklist.webapp.security.UserReader;
import io.camunda.tasklist.webapp.security.identity.IdentityAuthorizationService;
import io.camunda.tasklist.webapp.service.TaskService;
import io.camunda.tasklist.webapp.service.VariableService;
import io.camunda.webapps.schema.entities.tasklist.TaskEntity;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Task", description="API to query and manage tasks.")
@RestController
@RequestMapping(value={"/v1/tasks"}, produces={"application/json"})
public class TaskController
extends ApiErrorController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskController.class);
    private static final String ZEEBE_USER_TASK_OPERATIONS_NOT_SUPPORTED = "This operation is not supported using Tasklist V1 API. Please use the latest API. For more information, refer to the documentation: %s";
    private static final String USER_DOES_NOT_HAVE_ACCESS_TO_THIS_TASK_ERROR = "User does not have permission to perform on this task.";
    @Autowired
    private TaskService taskService;
    @Autowired
    private VariableService variableService;
    @Autowired
    private TaskMapper taskMapper;
    @Autowired
    private UserReader userReader;
    @Autowired
    private IdentityAuthorizationService identityAuthorizationService;
    @Autowired
    private TasklistProperties tasklistProperties;

    @Operation(summary="Search tasks", description="Returns the list of tasks that satisfy search request params.<br><ul><li>If an empty body is provided, all tasks are returned.</li><li>Only one of `[searchAfter, searchAfterOrEqual, searchBefore, searchBeforeOrEqual]` search options must be present in request.</li></ul>", responses={@ApiResponse(description="On success returned.", responseCode="200", useReturnTypeSchema=true), @ApiResponse(description="An error is returned when more than one search parameters among `[searchAfter, searchAfterOrEqual, searchBefore, searchBeforeOrEqual]` are present in request", responseCode="400", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))})})
    @PostMapping(value={"search"})
    public ResponseEntity<List<TaskSearchResponse>> searchTasks(@org.springframework.web.bind.annotation.RequestBody(required=false) TaskSearchRequest searchRequest) {
        List<String> listOfUserGroups;
        TaskQueryDTO query = this.taskMapper.toTaskQuery(Objects.requireNonNullElse(searchRequest, new TaskSearchRequest()));
        if (this.tasklistProperties.getIdentity() != null && this.tasklistProperties.getIdentity().isUserAccessRestrictionsEnabled() && !(listOfUserGroups = this.identityAuthorizationService.getUserGroups()).contains("")) {
            String userName = this.userReader.getCurrentUser().getUserId();
            TaskByCandidateUserOrGroup taskByCandidateUserOrGroup = new TaskByCandidateUserOrGroup();
            taskByCandidateUserOrGroup.setUserGroups((String[])listOfUserGroups.toArray(String[]::new));
            taskByCandidateUserOrGroup.setUserName(userName);
            query.setTaskByCandidateUserOrGroup(taskByCandidateUserOrGroup);
        }
        Map<String, Boolean> contextVariables = Map.of("taskContextDisplayName", false);
        HashMap<String, Boolean> variableNamesToReturnFullValue = new HashMap<String, Boolean>();
        variableNamesToReturnFullValue.put("taskContextDisplayName", false);
        variableNamesToReturnFullValue.putAll(Optional.ofNullable(searchRequest).map(TaskSearchRequest::getIncludeVariables).map(variables -> Arrays.stream(variables).collect(Collectors.toMap(IncludeVariable::getName, IncludeVariable::isAlwaysReturnFullValue))).orElse(Collections.emptyMap()));
        Set<String> includeVariableNames = variableNamesToReturnFullValue.keySet();
        boolean fetchFullValuesFromDB = variableNamesToReturnFullValue.entrySet().stream().anyMatch(Map.Entry::getValue);
        List tasks = this.taskService.getTasks(query, includeVariableNames, fetchFullValuesFromDB).stream().map(this.taskMapper::toTaskSearchResponse).collect(Collectors.toList());
        tasks.stream().map(TaskSearchResponse::getVariables).filter(Objects::nonNull).flatMap(Arrays::stream).forEach(resp -> this.unsetBigVariableValuesIfNeeded((VariableSearchResponse)resp, (Map<String, Boolean>)variableNamesToReturnFullValue));
        return ResponseEntity.ok(tasks);
    }

    private void unsetBigVariableValuesIfNeeded(VariableSearchResponse resp, Map<String, Boolean> variableNamesToReturnFullValue) {
        VariableSearchResponse.DraftSearchVariableValue draft;
        boolean returnFullValue = Optional.ofNullable(variableNamesToReturnFullValue.get(resp.getName())).orElse(false);
        if (resp.getIsValueTruncated() && !returnFullValue) {
            resp.resetValue();
        }
        if ((draft = resp.getDraft()) != null && draft.getIsValueTruncated() && !returnFullValue) {
            draft.resetValue();
        }
    }

    @Operation(summary="Get a task", description="Get one task by id. Returns task or error when task does not exist.", responses={@ApiResponse(description="On success returned.", responseCode="200", useReturnTypeSchema=true), @ApiResponse(description="An error is returned when the task with the `taskId` is not found.", responseCode="404", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))}), @ApiResponse(description="User has no permission to access the task (Self-managed only).", responseCode="403", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))})})
    @GetMapping(value={"{taskId}"})
    public ResponseEntity<TaskResponse> getTaskById(@PathVariable @Parameter(description="The ID of the task.", required=true) String taskId) {
        LazySupplier<TaskDTO> taskSupplier = this.getTaskSupplier(taskId);
        if (!this.isUserRestrictionEnabled() || this.hasAccessToTask(taskSupplier)) {
            return ResponseEntity.ok((Object)this.taskMapper.toTaskResponse((TaskDTO)taskSupplier.get()));
        }
        throw new ForbiddenActionException(USER_DOES_NOT_HAVE_ACCESS_TO_THIS_TASK_ERROR);
    }

    private void checkTaskImplementation(LazySupplier<TaskDTO> taskSupplier) {
        if (((TaskDTO)taskSupplier.get()).getImplementation() != TaskEntity.TaskImplementation.JOB_WORKER && this.userReader.getCurrentUser().isApiUser()) {
            TaskDTO task = (TaskDTO)taskSupplier.get();
            LOGGER.warn("V1 API is used for task with id={} implementation={}", (Object)task.getId(), (Object)task.getImplementation());
            throw new InvalidRequestException(String.format(ZEEBE_USER_TASK_OPERATIONS_NOT_SUPPORTED, this.tasklistProperties.getDocumentation().getApiMigrationDocsUrl()));
        }
    }

    private boolean hasAccessToTask(LazySupplier<TaskDTO> taskSupplier) {
        String userName = this.userReader.getCurrentUser().getUserId();
        List<String> listOfUserGroups = this.identityAuthorizationService.getUserGroups();
        TaskDTO task = (TaskDTO)taskSupplier.get();
        boolean allUsersTask = task.getCandidateUsers() == null && task.getCandidateGroups() == null;
        boolean candidateGroupTasks = task.getCandidateGroups() != null && !Collections.disjoint(Arrays.asList(task.getCandidateGroups()), listOfUserGroups);
        boolean candidateUserTasks = task.getCandidateUsers() != null && Arrays.asList(task.getCandidateUsers()).contains(userName);
        boolean assigneeTasks = task.getAssignee() != null && task.getAssignee().equals(userName);
        boolean noRestrictions = listOfUserGroups.contains("");
        return candidateUserTasks || assigneeTasks || candidateGroupTasks || allUsersTask || noRestrictions;
    }

    @Operation(summary="Assign a task", description="Assign a task with `taskId` to `assignee` or the active user. Returns the task.", requestBody=@RequestBody(description="When using REST API with JWT authentication token following request body parameters may be used."), responses={@ApiResponse(description="On success returned.", responseCode="200", useReturnTypeSchema=true), @ApiResponse(description="An error is returned when the task is not active (not in the CREATED state).<br>An error is returned when task was already assigned, except the case when JWT authentication token used and `allowOverrideAssignment = true`.", responseCode="400", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))}), @ApiResponse(description="An error is returned when user doesn't have the permission to assign another user to this task.", responseCode="403", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))}), @ApiResponse(description="An error is returned when the task with the `taskId` is not found.", responseCode="404", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))})})
    @PreAuthorize(value="hasPermission('write')")
    @PatchMapping(value={"{taskId}/assign"})
    public ResponseEntity<TaskResponse> assignTask(@PathVariable @Parameter(description="The ID of the task.", required=true) String taskId, @org.springframework.web.bind.annotation.RequestBody(required=false) TaskAssignRequest assignRequest) {
        this.checkTaskImplementation(this.getTaskSupplier(taskId));
        TaskAssignRequest safeAssignRequest = Objects.requireNonNullElse(assignRequest, new TaskAssignRequest());
        TaskDTO assignedTask = this.taskService.assignTask(taskId, safeAssignRequest.getAssignee(), safeAssignRequest.isAllowOverrideAssignment());
        return ResponseEntity.ok((Object)this.taskMapper.toTaskResponse(assignedTask));
    }

    @Operation(summary="Unassign a task", description="Unassign a task with `taskId`. Returns the task.", responses={@ApiResponse(description="On success returned.", responseCode="200", useReturnTypeSchema=true), @ApiResponse(description="An error is returned when the task is not active (not in the CREATED state).<br>An error is returned if the task was not claimed (assigned) before.", responseCode="400", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))}), @ApiResponse(description="An error is returned when the task with the `taskId` is not found.", responseCode="404", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))})})
    @PreAuthorize(value="hasPermission('write')")
    @PatchMapping(value={"{taskId}/unassign"})
    public ResponseEntity<TaskResponse> unassignTask(@PathVariable @Parameter(description="The ID of the task.", required=true) String taskId) {
        this.checkTaskImplementation(this.getTaskSupplier(taskId));
        TaskDTO unassignedTask = this.taskService.unassignTask(taskId);
        return ResponseEntity.ok((Object)this.taskMapper.toTaskResponse(unassignedTask));
    }

    @Operation(summary="Complete a task", description="Complete a task with `taskId` and optional `variables`. Returns the task.", responses={@ApiResponse(description="On success returned.", responseCode="200", useReturnTypeSchema=true), @ApiResponse(description="An error is returned when the task is not active (not in the CREATED state).<br>An error is returned if the task was not claimed (assigned) before.<br>An error is returned if the task is not assigned to the current user.", responseCode="400", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))}), @ApiResponse(description="User has no permission to access the task (Self-managed only).", responseCode="403", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))}), @ApiResponse(description="An error is returned when the task with the `taskId` is not found.", responseCode="404", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))})})
    @PreAuthorize(value="hasPermission('write')")
    @PatchMapping(value={"{taskId}/complete"})
    public ResponseEntity<TaskResponse> completeTask(@PathVariable @Parameter(description="The ID of the task.", required=true) String taskId, @org.springframework.web.bind.annotation.RequestBody(required=false) TaskCompleteRequest taskCompleteRequest) {
        List<VariableInputDTO> variables = Objects.requireNonNullElse(taskCompleteRequest, new TaskCompleteRequest()).getVariables();
        LazySupplier<TaskDTO> taskSupplier = this.getTaskSupplier(taskId);
        this.checkTaskImplementation(taskSupplier);
        if (!this.isUserRestrictionEnabled() || this.hasAccessToTask(taskSupplier)) {
            TaskDTO completedTask = this.taskService.completeTask(taskId, variables, true);
            return ResponseEntity.ok((Object)this.taskMapper.toTaskResponse(completedTask));
        }
        throw new ForbiddenActionException(USER_DOES_NOT_HAVE_ACCESS_TO_THIS_TASK_ERROR);
    }

    private boolean isUserRestrictionEnabled() {
        if (this.tasklistProperties.getIdentity() != null) {
            return this.tasklistProperties.getIdentity().isUserAccessRestrictionsEnabled();
        }
        return false;
    }

    @Operation(summary="Save draft variables", description="This operation performs several actions: <br/><ol><li>Validates the task and draft variables.</li><li>Deletes existing draft variables for the task.</li><li>Checks for new draft variables. If a new variable's `name` matches an existing one but the `value` differs, it is saved. In case of duplicate draft variable names, the last variable's value is kept.</li></ol><b>NOTE:</b><ul><li>Invoking this method successively will overwrite all existing draft variables. Only draft variables submitted in the most recent request body will be persisted. Therefore, ensure you include all necessary variables in each request to maintain the intended variable set.</li><li>The UI does not currently display the values for draft variables that are created via this endpoint.</li></ul>", responses={@ApiResponse(responseCode="204", description="On success returned.", content={@Content(mediaType="*/*")}), @ApiResponse(responseCode="400", description="An error is returned when the task is not active (not in the `CREATED` state).<br/>An error is returned if the task was not claimed (assigned) before, except the case when JWT authentication token used.<br/>An error is returned if the task is not assigned to the current user, except the case when JWT authentication token used.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="404", description="An error is returned when the task with the `taskId` is not found.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="500", description="An error is returned if an unexpected error occurs while persisting draft task variables.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))})})
    @PreAuthorize(value="hasPermission('write')")
    @PostMapping(value={"{taskId}/variables"})
    public ResponseEntity<Void> saveDraftTaskVariables(@PathVariable @Parameter(description="The ID of the task.", required=true) String taskId, @org.springframework.web.bind.annotation.RequestBody SaveVariablesRequest saveVariablesRequest) {
        if (this.isUserRestrictionEnabled() && !this.hasAccessToTask(this.getTaskSupplier(taskId))) {
            throw new ForbiddenActionException(USER_DOES_NOT_HAVE_ACCESS_TO_THIS_TASK_ERROR);
        }
        this.variableService.persistDraftTaskVariables(taskId, saveVariablesRequest.getVariables());
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Search task variables", description="This method returns a list of task variables for the specified `taskId` and `variableName`.<br>If the request body is not provided or if the `variableNames` parameter in the request is empty, all variables associated with the task will be returned.", responses={@ApiResponse(description="On success returned.", responseCode="200", useReturnTypeSchema=true), @ApiResponse(description="An error is returned when the task with the `taskId` is not found.", responseCode="404", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))})})
    @PostMapping(value={"{taskId}/variables/search"})
    public ResponseEntity<List<VariableSearchResponse>> searchTaskVariables(@PathVariable @Parameter(description="The ID of the task.", required=true) String taskId, @org.springframework.web.bind.annotation.RequestBody(required=false) VariablesSearchRequest variablesSearchRequest) {
        Map<Object, Object> variableNamesToReturnFullValue;
        if (variablesSearchRequest != null) {
            if (CollectionUtils.isNotEmpty(variablesSearchRequest.getVariableNames()) && CollectionUtils.isNotEmpty(variablesSearchRequest.getIncludeVariables())) {
                throw new InvalidRequestException("Only one of [variableNames, includeVariables] must be present in request.");
            }
            variableNamesToReturnFullValue = CollectionUtils.isNotEmpty(variablesSearchRequest.getVariableNames()) ? variablesSearchRequest.getVariableNames().stream().collect(Collectors.toMap(Function.identity(), k -> false)) : (CollectionUtils.isNotEmpty(variablesSearchRequest.getIncludeVariables()) ? variablesSearchRequest.getIncludeVariables().stream().collect(Collectors.toMap(IncludeVariable::getName, IncludeVariable::isAlwaysReturnFullValue)) : Collections.emptyMap());
        } else {
            variableNamesToReturnFullValue = Collections.emptyMap();
        }
        List<VariableSearchResponse> variables = this.variableService.getVariableSearchResponses(taskId, variableNamesToReturnFullValue.keySet());
        variables.forEach(resp -> this.unsetBigVariableValuesIfNeeded((VariableSearchResponse)resp, (Map<String, Boolean>)variableNamesToReturnFullValue));
        return ResponseEntity.ok(variables);
    }

    private LazySupplier<TaskDTO> getTaskSupplier(String taskId) {
        return LazySupplier.of(() -> this.taskService.getTask(taskId));
    }
}

