/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.api.rest.v1.controllers;

import io.camunda.tasklist.store.FormStore;
import io.camunda.tasklist.webapp.api.rest.v1.controllers.ApiErrorController;
import io.camunda.tasklist.webapp.api.rest.v1.entities.FormResponse;
import io.camunda.tasklist.webapp.rest.exception.Error;
import io.camunda.webapps.schema.entities.tasklist.FormEntity;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Form", description="API to query forms.")
@RestController
@RequestMapping(value={"/v1/forms"}, produces={"application/json"})
public class FormController
extends ApiErrorController {
    @Autowired
    private FormStore formStore;

    @Operation(summary="Get a form", description="Get the form details by `formId` and `processDefinitionKey` required query param. The `version` query param is optional and is used only for deployed forms (if empty, it retrieves the highest version).", responses={@ApiResponse(description="On success returned.", responseCode="200", useReturnTypeSchema=true), @ApiResponse(description="An error is returned when the form with the `formId` and `processDefinitionKey` is not found.", responseCode="404", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Error.class))})})
    @GetMapping(value={"{formId}"})
    public ResponseEntity<FormResponse> getForm(@PathVariable @Parameter(description="The ID of the form.", required=true) String formId, @RequestParam @Parameter(description="Reference to the process definition.", required=true) String processDefinitionKey, @RequestParam(required=false) @Parameter(description="The version of the form. Valid only for deployed forms.", required=false) Long version) {
        FormEntity form = this.formStore.getForm(formId, processDefinitionKey, version);
        if (form.getProcessDefinitionId() == null) {
            form.setProcessDefinitionId(processDefinitionKey);
        }
        return ResponseEntity.ok((Object)FormResponse.fromFormEntity(form));
    }
}

