/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.entities.ProcessEntity;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.store.ProcessStore;
import io.camunda.tasklist.webapp.graphql.entity.ProcessInstanceDTO;
import io.camunda.tasklist.webapp.graphql.entity.VariableInputDTO;
import io.camunda.tasklist.webapp.rest.exception.ForbiddenActionException;
import io.camunda.tasklist.webapp.rest.exception.InvalidRequestException;
import io.camunda.tasklist.webapp.security.UserReader;
import io.camunda.tasklist.webapp.security.identity.IdentityAuthorizationService;
import io.camunda.tasklist.webapp.security.tenant.TenantService;
import io.camunda.tasklist.webapp.service.TasklistServicesAdapter;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ProcessService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessService.class);
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private IdentityAuthorizationService identityAuthorizationService;
    @Autowired
    private UserReader userReader;
    @Autowired
    private ProcessStore processStore;
    @Autowired
    private TasklistServicesAdapter tasklistServicesAdapter;

    public ProcessEntity getProcessByProcessDefinitionKeyAndAccessRestriction(String processDefinitionKey) {
        ProcessEntity processEntity = this.processStore.getProcessByProcessDefinitionKey(processDefinitionKey);
        List<String> processReadAuthorizations = this.identityAuthorizationService.getProcessReadFromAuthorization();
        if (processReadAuthorizations.contains(processEntity.getBpmnProcessId()) || processReadAuthorizations.contains("*")) {
            return processEntity;
        }
        throw new ForbiddenActionException("Resource cannot be accessed");
    }

    public ProcessInstanceDTO startProcessInstance(String processDefinitionKey, String tenantId) {
        return this.startProcessInstance(processDefinitionKey, null, tenantId);
    }

    public ProcessInstanceDTO startProcessInstance(String processDefinitionKey, List<VariableInputDTO> variables, String tenantId) {
        return this.startProcessInstance(processDefinitionKey, variables, tenantId, true);
    }

    public ProcessInstanceDTO startProcessInstance(String processDefinitionKey, List<VariableInputDTO> variables, String tenantId, boolean executeWithAuthentication) {
        if (!executeWithAuthentication && !this.identityAuthorizationService.isAllowedToStartProcess(processDefinitionKey)) {
            throw new ForbiddenActionException("User does not have the permission to start this process.");
        }
        boolean isMultiTenancyEnabled = this.tenantService.isMultiTenancyEnabled();
        if (isMultiTenancyEnabled && !this.tenantService.getAuthenticatedTenants().contains(tenantId)) {
            throw new InvalidRequestException("Invalid tenant.");
        }
        Map<String, Object> variablesMap = CollectionUtils.isNotEmpty(variables) ? variables.stream().collect(Collectors.toMap(VariableInputDTO::getName, this::extractTypedValue)) : null;
        ProcessInstanceCreationRecord processInstanceEvent = Optional.of(executeWithAuthentication).filter(Boolean::booleanValue).map(i -> this.tasklistServicesAdapter.createProcessInstance(processDefinitionKey, variablesMap, tenantId)).orElseGet(() -> this.tasklistServicesAdapter.createProcessInstanceWithoutAuthentication(processDefinitionKey, variablesMap, tenantId));
        LOGGER.debug("Process instance created for process [{}]", (Object)processDefinitionKey);
        return new ProcessInstanceDTO().setId(processInstanceEvent.getProcessInstanceKey());
    }

    private Object extractTypedValue(VariableInputDTO variable) {
        if (variable.getValue().equals("null")) {
            return this.objectMapper.nullNode();
        }
        try {
            return this.objectMapper.readValue(variable.getValue(), Object.class);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(e.getMessage(), (Throwable)e);
        }
    }
}

