/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.service;

import io.camunda.service.CamundaServiceException;
import io.camunda.service.JobServices;
import io.camunda.service.ProcessInstanceServices;
import io.camunda.service.UserTaskServices;
import io.camunda.service.security.auth.Authentication;
import io.camunda.tasklist.entities.TaskEntity;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.webapp.rest.exception.ForbiddenActionException;
import io.camunda.tasklist.webapp.rest.exception.InvalidRequestException;
import io.camunda.tasklist.webapp.rest.exception.NotFoundApiException;
import io.camunda.tasklist.webapp.security.tenant.TenantService;
import io.camunda.tasklist.webapp.service.TasklistServicesAdapter;
import io.camunda.zeebe.broker.client.api.BrokerErrorException;
import io.camunda.zeebe.broker.client.api.BrokerRejectionException;
import io.camunda.zeebe.gateway.rest.RequestMapper;
import io.camunda.zeebe.gateway.rest.validator.MultiTenancyValidator;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.protocol.record.ErrorCode;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.util.Either;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import org.springframework.context.annotation.Profile;
import org.springframework.http.ProblemDetail;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"!standalone"})
public class CamundaServicesBasedAdapter
implements TasklistServicesAdapter {
    private final TenantService tenantService;
    private final ProcessInstanceServices processInstanceServices;
    private final UserTaskServices userTaskServices;
    private final JobServices<?> jobServices;

    public CamundaServicesBasedAdapter(TenantService tenantService, ProcessInstanceServices processInstanceServices, UserTaskServices userTaskServices, JobServices<?> jobServices) {
        this.tenantService = tenantService;
        this.processInstanceServices = processInstanceServices;
        this.userTaskServices = userTaskServices;
        this.jobServices = jobServices;
    }

    @Override
    public ProcessInstanceCreationRecord createProcessInstance(String bpmnProcessId, Map<String, Object> variables, String tenantId) {
        return (ProcessInstanceCreationRecord)this.executeCamundaServiceAuthenticated(this.createProcessInstanceFunction(bpmnProcessId, variables, tenantId));
    }

    @Override
    public ProcessInstanceCreationRecord createProcessInstanceWithoutAuthentication(String bpmnProcessId, Map<String, Object> variables, String tenantId) {
        return (ProcessInstanceCreationRecord)this.executeCamundaServiceAnonymously(this.createProcessInstanceFunction(bpmnProcessId, variables, tenantId));
    }

    @Override
    public void assignUserTask(TaskEntity task, String assignee) {
        if (!this.isJobBasedUserTask(task)) {
            this.assignCamundaUserTask(task, assignee);
        }
    }

    @Override
    public void unassignUserTask(TaskEntity task) {
        if (!this.isJobBasedUserTask(task)) {
            this.unassignCamundaUserTask(task);
        }
    }

    @Override
    public void completeUserTask(TaskEntity task, Map<String, Object> variables) {
        if (this.isJobBasedUserTask(task)) {
            this.completeJobBasedUserTask(task, variables);
        } else {
            this.completeCamundaUserTask(task, variables);
        }
    }

    private Function<Authentication, CompletableFuture<ProcessInstanceCreationRecord>> createProcessInstanceFunction(String bpmnProcessId, Map<String, Object> variables, String tenantId) {
        return authentication -> this.processInstanceServices.withAuthentication(authentication).createProcessInstance(this.toProcessInstanceCreateRequest(bpmnProcessId, variables, tenantId));
    }

    private void assignCamundaUserTask(TaskEntity task, String assignee) {
        this.executeCamundaServiceAuthenticated(authentication -> this.userTaskServices.withAuthentication(authentication).assignUserTask(task.getKey(), assignee, "", true));
    }

    private void unassignCamundaUserTask(TaskEntity task) {
        this.executeCamundaServiceAuthenticated(authentication -> this.userTaskServices.withAuthentication(authentication).unassignUserTask(task.getKey(), ""));
    }

    private void completeJobBasedUserTask(TaskEntity task, Map<String, Object> variables) {
        this.executeCamundaServiceAuthenticated(authentication -> this.jobServices.withAuthentication(authentication).completeJob(task.getKey(), variables));
    }

    private void completeCamundaUserTask(TaskEntity task, Map<String, Object> variables) {
        this.executeCamundaServiceAuthenticated(authentication -> this.userTaskServices.withAuthentication(authentication).completeUserTask(task.getKey(), variables, ""));
    }

    private ProcessInstanceServices.ProcessInstanceCreateRequest toProcessInstanceCreateRequest(String bpmnProcessId, Map<String, Object> variables, String tenantId) {
        Either tenantValidationResult = MultiTenancyValidator.validateTenantId((String)tenantId, (boolean)this.tenantService.isMultiTenancyEnabled(), (String)"Create Process Instance");
        if (tenantValidationResult.isLeft()) {
            throw new InvalidRequestException(((ProblemDetail)tenantValidationResult.getLeft()).getDetail());
        }
        String tenant = (String)tenantValidationResult.get();
        return new ProcessInstanceServices.ProcessInstanceCreateRequest(Long.valueOf(-1L), bpmnProcessId, Integer.valueOf(-1), variables, tenant, null, null, null, List.of(), null);
    }

    private <T> T executeCamundaServiceAuthenticated(Function<Authentication, CompletableFuture<T>> method) {
        return this.executeCamundaService(method, RequestMapper.getAuthentication());
    }

    private <T> T executeCamundaServiceAnonymously(Function<Authentication, CompletableFuture<T>> method) {
        return this.executeCamundaService(method, RequestMapper.getAnonymousAuthentication());
    }

    private <T> T executeCamundaService(Function<Authentication, CompletableFuture<T>> method, Authentication authentication) {
        try {
            return method.apply(authentication).join();
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    private RuntimeException handleException(Throwable error) {
        Throwable throwable = error;
        Objects.requireNonNull(throwable);
        Throwable throwable2 = throwable;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CompletionException.class, CamundaServiceException.class}, (Object)throwable2, n)) {
            case 0 -> {
                CompletionException ce = (CompletionException)throwable2;
                yield this.handleException(ce.getCause());
            }
            case 1 -> {
                CamundaServiceException cbe = (CamundaServiceException)throwable2;
                yield this.mapCamundaBrokerException(cbe);
            }
            default -> new RuntimeException("Failed to execute request: " + error.getMessage(), error);
        };
    }

    private RuntimeException mapCamundaBrokerException(CamundaServiceException exception) {
        BrokerErrorException brokerError;
        ErrorCode errorCode;
        Throwable rejection;
        Throwable throwable = exception.getCause();
        if (throwable instanceof BrokerRejectionException) {
            BrokerRejectionException brokerRejection = (BrokerRejectionException)throwable;
            rejection = brokerRejection.getRejection();
            String message = String.format("Request '%s' rejected with code '%s': %s", rejection.intent(), rejection.type(), rejection.reason());
            RejectionType type = rejection.type();
            if (type.equals((Object)RejectionType.NOT_FOUND)) {
                return new NotFoundApiException(message, (Throwable)exception);
            }
            if (type.equals((Object)RejectionType.UNAUTHORIZED)) {
                return new ForbiddenActionException(message, (Throwable)exception);
            }
        }
        if ((rejection = exception.getCause()) instanceof BrokerErrorException && (errorCode = (brokerError = (BrokerErrorException)rejection).getError().getCode()).equals((Object)ErrorCode.PROCESS_NOT_FOUND)) {
            return new ForbiddenActionException("Process not found", (Throwable)exception);
        }
        return new TasklistRuntimeException(String.format("Failed to execute request with %s", exception.getMessage()), (Throwable)exception);
    }
}

