/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security.tenant;

import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.webapp.security.tenant.TasklistTenant;
import io.camunda.tasklist.webapp.security.tenant.TenantAwareAuthentication;
import io.camunda.tasklist.webapp.security.tenant.TenantService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class TenantServiceImpl
implements TenantService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantServiceImpl.class);
    @Autowired
    private TasklistProperties tasklistProperties;

    @Override
    public TenantService.AuthenticatedTenants getAuthenticatedTenants() {
        if (!this.isMultiTenancyEnabled()) {
            return TenantService.AuthenticatedTenants.allTenants();
        }
        TenantAwareAuthentication authentication = this.getCurrentTenantAwareAuthentication();
        List<String> tenants = this.getTenantsFromAuthentication(authentication);
        if (CollectionUtils.isNotEmpty(tenants)) {
            return TenantService.AuthenticatedTenants.assignedTenants(tenants);
        }
        return TenantService.AuthenticatedTenants.noTenantsAssigned();
    }

    @Override
    public boolean isTenantValid(String tenantId) {
        if (this.isMultiTenancyEnabled()) {
            return this.getAuthenticatedTenants().contains(tenantId);
        }
        return true;
    }

    @Override
    public boolean isMultiTenancyEnabled() {
        return this.tasklistProperties.getMultiTenancy().isEnabled() && SecurityContextHolder.getContext().getAuthentication() != null;
    }

    private TenantAwareAuthentication getCurrentTenantAwareAuthentication() {
        TenantAwareAuthentication currentAuthentication;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof TenantAwareAuthentication) {
            TenantAwareAuthentication tenantAwareAuthentication;
            currentAuthentication = tenantAwareAuthentication = (TenantAwareAuthentication)authentication;
        } else {
            currentAuthentication = null;
            String message = String.format("Multi Tenancy is not supported with current authentication type %s", authentication.getClass());
            LOGGER.error(message, (Throwable)new TasklistRuntimeException());
        }
        return currentAuthentication;
    }

    private List<String> getTenantsFromAuthentication(TenantAwareAuthentication authentication) {
        List<TasklistTenant> tenants;
        ArrayList<String> authenticatedTenants = new ArrayList<String>();
        if (authentication != null && (tenants = authentication.getTenants()) != null && !tenants.isEmpty()) {
            tenants.stream().map(TasklistTenant::getId).collect(Collectors.toCollection(() -> authenticatedTenants));
        }
        return authenticatedTenants;
    }
}

