/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security.sso;

import io.camunda.tasklist.webapp.security.sso.Auth0Service;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Profile(value={"sso-auth"})
public class SSOController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSOController.class);
    @Autowired
    private Auth0Service auth0Service;
    private final SecurityContextRepository securityContextRepository = new HttpSessionSecurityContextRepository();
    private final SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();

    @RequestMapping(value={"/api/login"}, method={RequestMethod.GET, RequestMethod.POST})
    public String login(HttpServletRequest req, HttpServletResponse res) {
        String authorizeUrl = this.auth0Service.getAuthorizeUrl(req, res);
        LOGGER.debug("Redirect Login to {}", (Object)authorizeUrl);
        return "redirect:" + authorizeUrl;
    }

    @GetMapping(value={"/sso-callback"})
    public void loggedInCallback(HttpServletRequest req, HttpServletResponse res) throws IOException {
        LOGGER.debug("Called back by auth0 with {} {} and SessionId: {}", new Object[]{req.getRequestURI(), req.getQueryString(), req.getSession().getId()});
        try {
            Authentication authentication = this.auth0Service.authenticate(req, res);
            SecurityContext context = this.securityContextHolderStrategy.createEmptyContext();
            context.setAuthentication(authentication);
            this.securityContextHolderStrategy.setContext(context);
            this.securityContextRepository.saveContext(context, req, res);
            this.sessionExpiresWhenAuthenticationExpires(req);
            this.redirectToPage(req, res);
        }
        catch (Exception t) {
            this.clearContextAndRedirectToNoPermission(req, res, t);
        }
    }

    private void redirectToPage(HttpServletRequest req, HttpServletResponse res) throws IOException {
        Object originalRequestUrl = req.getSession().getAttribute("requestedUrl");
        if (originalRequestUrl != null) {
            res.sendRedirect(req.getContextPath() + String.valueOf(originalRequestUrl));
        } else {
            res.sendRedirect(req.getContextPath() + "/tasklist");
        }
    }

    @RequestMapping(value={"/noPermission"})
    @ResponseBody
    public String noPermissions() {
        return "No permission for Tasklist - Please check your Tasklist configuration or cloud configuration.";
    }

    @RequestMapping(value={"/api/logout"})
    public void logout(HttpServletRequest req, HttpServletResponse res) throws IOException {
        LOGGER.debug("logout user");
        this.cleanup(req);
        this.logoutFromAuth0(res, this.auth0Service.getRedirectURI(req, "/tasklist"));
    }

    protected void clearContextAndRedirectToNoPermission(HttpServletRequest req, HttpServletResponse res, Throwable t) throws IOException {
        LOGGER.error("Error in authentication callback: ", t);
        this.cleanup(req);
        res.sendRedirect(req.getContextPath() + "/noPermission");
    }

    protected void logoutAndRedirectToNoPermissionPage(HttpServletRequest req, HttpServletResponse res) throws IOException {
        LOGGER.error("User is authenticated but there are no permissions. Show noPermission message");
        this.cleanup(req);
        this.logoutFromAuth0(res, this.auth0Service.getRedirectURI(req, "/noPermission"));
    }

    protected void cleanup(HttpServletRequest req) {
        req.getSession().invalidate();
        SecurityContext context = this.securityContextHolderStrategy.getContext();
        if (context != null) {
            context.setAuthentication(null);
            this.securityContextHolderStrategy.clearContext();
        }
    }

    protected void logoutFromAuth0(HttpServletResponse res, String returnTo) throws IOException {
        res.sendRedirect(this.auth0Service.getLogoutUrlFor(returnTo));
    }

    private void sessionExpiresWhenAuthenticationExpires(HttpServletRequest req) {
        req.getSession().setMaxInactiveInterval(-1);
    }
}

