/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security.se;

import io.camunda.tasklist.util.CollectionUtil;
import io.camunda.tasklist.webapp.security.se.Role;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class User
extends org.springframework.security.core.userdetails.User {
    private String userId;
    private String displayName;
    private List<Role> roles;

    public User(String username, String password, List<Role> roles) {
        super(username, password, User.toAuthorities(roles));
        this.roles = roles;
        this.userId = username;
    }

    public String getUserId() {
        return this.userId;
    }

    public User setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public User setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public User setRoles(List<Role> roles) {
        this.roles = roles;
        return this;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    private static Collection<? extends GrantedAuthority> toAuthorities(List<Role> roles) {
        return CollectionUtil.map(roles, role -> new SimpleGrantedAuthority("ROLE_" + String.valueOf(role)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        User user = (User)((Object)o);
        return Objects.equals(this.userId, user.userId) && Objects.equals(this.displayName, user.displayName) && Objects.equals(this.roles, user.roles);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userId, this.displayName, this.roles);
    }
}

