/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security.oauth;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.tasklist.webapp.security.BaseWebConfigurer;
import io.camunda.tasklist.webapp.security.oauth.IdentityJwt2AuthenticationTokenConverter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.env.Environment;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"identity-auth"})
public class IdentityOAuth2WebConfigurer {
    public static final String SPRING_SECURITY_OAUTH_2_RESOURCESERVER_JWT_ISSUER_URI = "spring.security.oauth2.resourceserver.jwt.issuer-uri";
    public static final String SPRING_SECURITY_OAUTH_2_RESOURCESERVER_JWT_JWK_SET_URI = "spring.security.oauth2.resourceserver.jwt.jwk-set-uri";
    public static final String JWKS_PATH = "/protocol/openid-connect/certs";
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentityOAuth2WebConfigurer.class);
    private final Environment env;
    private final IdentityConfiguration identityConfiguration;
    private final IdentityJwt2AuthenticationTokenConverter jwtConverter;

    public IdentityOAuth2WebConfigurer(Environment env, IdentityConfiguration identityConfiguration, IdentityJwt2AuthenticationTokenConverter jwtConverter) {
        this.env = env;
        this.identityConfiguration = identityConfiguration;
        this.jwtConverter = jwtConverter;
    }

    public void configure(HttpSecurity http) throws Exception {
        if (this.isJWTEnabled()) {
            http.oauth2ResourceServer(serverCustomizer -> serverCustomizer.authenticationEntryPoint(this::authenticationFailure).jwt(jwtCustomizer -> jwtCustomizer.jwtAuthenticationConverter((Converter)this.jwtConverter).decoder(this.jwtDecoder())));
            LOGGER.info("Enabled OAuth2 JWT access to Tasklist API");
        }
    }

    private JwtDecoder jwtDecoder() {
        return NimbusJwtDecoder.withJwkSetUri((String)this.getJwkSetUriProperty()).jwsAlgorithms(algorithms -> algorithms.addAll(List.of(SignatureAlgorithm.RS256, SignatureAlgorithm.RS384, SignatureAlgorithm.RS512, SignatureAlgorithm.ES256, SignatureAlgorithm.ES384, SignatureAlgorithm.ES512))).jwtProcessorCustomizer(processor -> processor.setJWSTypeVerifier((JOSEObjectTypeVerifier)new DefaultJOSEObjectTypeVerifier(new JOSEObjectType[]{JOSEObjectType.JWT, new JOSEObjectType("at+jwt"), null}))).build();
    }

    private String getJwkSetUriProperty() {
        Object backendUri;
        if (this.env.containsProperty(SPRING_SECURITY_OAUTH_2_RESOURCESERVER_JWT_JWK_SET_URI)) {
            backendUri = this.env.getProperty(SPRING_SECURITY_OAUTH_2_RESOURCESERVER_JWT_JWK_SET_URI);
            LOGGER.info("Using value in SPRING_SECURITY_OAUTH_2_RESOURCESERVER_JWT_JWK_SET_URI for issuer authentication");
        } else {
            backendUri = this.identityConfiguration.getIssuerBackendUrl() + JWKS_PATH;
            LOGGER.warn("SPRING_SECURITY_OAUTH_2_RESOURCESERVER_JWT_JWK_SET_URI is not present, building issuer authentication uri from issuer backend url.");
        }
        LOGGER.info("Using {} for issuer authentication", backendUri);
        return backendUri;
    }

    private void authenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException e) throws IOException {
        BaseWebConfigurer.sendJSONErrorMessage(response, e.getMessage());
    }

    protected boolean isJWTEnabled() {
        return this.env.containsProperty(SPRING_SECURITY_OAUTH_2_RESOURCESERVER_JWT_ISSUER_URI) || this.env.containsProperty(SPRING_SECURITY_OAUTH_2_RESOURCESERVER_JWT_JWK_SET_URI);
    }
}

