/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security.identity;

import io.camunda.identity.autoconfigure.IdentityProperties;
import io.camunda.identity.sdk.Identity;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.util.SpringContextHolder;
import io.camunda.tasklist.webapp.security.identity.IdentityAuthentication;
import io.camunda.tasklist.webapp.security.identity.IdentityAuthorization;
import io.camunda.tasklist.webapp.security.identity.IdentityAuthorizationService;
import io.camunda.tasklist.webapp.security.sso.TokenAuthentication;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.stereotype.Component;

@Component
public class IdentityAuthorizationServiceImpl
implements IdentityAuthorizationService {
    private final Logger logger = LoggerFactory.getLogger(IdentityAuthorizationServiceImpl.class);
    @Autowired
    private TasklistProperties tasklistProperties;
    @Autowired
    private IdentityProperties identityProperties;

    @Override
    public List<String> getUserGroups() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String accessToken = null;
        Identity identity = (Identity)SpringContextHolder.getBean(Identity.class);
        if (authentication instanceof IdentityAuthentication) {
            accessToken = ((IdentityAuthentication)authentication).getTokens().getAccessToken();
            return identity.authentication().getGroups(accessToken);
        }
        if (authentication instanceof TokenAuthentication) {
            accessToken = ((TokenAuthentication)authentication).getAccessToken();
            String organization = ((TokenAuthentication)authentication).getOrganization();
            return identity.authentication().getGroupsInOrganization(accessToken, null, organization);
        }
        ArrayList<String> defaultGroups = new ArrayList<String>();
        defaultGroups.add("");
        return defaultGroups;
    }

    @Override
    public boolean isAllowedToStartProcess(String processDefinitionKey) {
        return !Collections.disjoint(this.getProcessDefinitionsFromAuthorization(), Set.of("*", processDefinitionKey));
    }

    @Override
    public List<String> getProcessReadFromAuthorization() {
        return this.getFromAuthorization("READ");
    }

    @Override
    public List<String> getProcessDefinitionsFromAuthorization() {
        return this.getFromAuthorization("START_PROCESS_INSTANCE");
    }

    private Optional<IdentityAuthorization> getIdentityAuthorization() {
        Authentication authentication;
        if (!this.tasklistProperties.getIdentity().isResourcePermissionsEnabled() || this.identityProperties.baseUrl() == null) {
            return Optional.empty();
        }
        Authentication authentication2 = authentication = SecurityContextHolder.getContext().getAuthentication();
        Objects.requireNonNull(authentication2);
        Authentication authentication3 = authentication2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IdentityAuthentication.class, JwtAuthenticationToken.class, TokenAuthentication.class}, (Object)authentication3, n)) {
            case 0 -> {
                IdentityAuthentication identityAuthentication = (IdentityAuthentication)authentication3;
                yield Optional.of(identityAuthentication.getAuthorizations());
            }
            case 1 -> {
                JwtAuthenticationToken jwtAuthenticationToken = (JwtAuthenticationToken)authentication3;
                Identity identity = (Identity)SpringContextHolder.getBean(Identity.class);
                yield Optional.of(new IdentityAuthorization(identity.authorizations().forToken(((Jwt)jwtAuthenticationToken.getToken()).getTokenValue())));
            }
            case 2 -> {
                TokenAuthentication tokenAuthentication = (TokenAuthentication)authentication3;
                Identity identity = (Identity)SpringContextHolder.getBean(Identity.class);
                yield Optional.of(new IdentityAuthorization(identity.authorizations().forToken(tokenAuthentication.getAccessToken(), tokenAuthentication.getOrganization())));
            }
            default -> Optional.empty();
        };
    }

    private List<String> getFromAuthorization(String type) {
        Optional<IdentityAuthorization> optIdentityAuthorization = this.getIdentityAuthorization();
        if (optIdentityAuthorization.isEmpty()) {
            return Collections.singletonList("*");
        }
        IdentityAuthorization identityAuthorization = optIdentityAuthorization.get();
        return switch (type) {
            case "READ" -> identityAuthorization.getProcessesAllowedToRead();
            case "START_PROCESS_INSTANCE" -> identityAuthorization.getProcessesAllowedToStart();
            default -> Collections.emptyList();
        };
    }
}

