/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security;

import io.camunda.tasklist.webapp.security.CustomSecurityExpressionRoot;
import io.camunda.tasklist.webapp.security.UserReader;
import java.util.function.Supplier;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionOperations;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class CustomMethodSecurityExpressionHandler
extends DefaultMethodSecurityExpressionHandler {
    @Autowired
    BeanFactory beanFactory;

    public EvaluationContext createEvaluationContext(Supplier<Authentication> authentication, MethodInvocation mi) {
        StandardEvaluationContext context = (StandardEvaluationContext)super.createEvaluationContext(authentication, mi);
        context.setRootObject((Object)this.createSecurityExpressionRoot(authentication.get(), mi));
        return context;
    }

    protected MethodSecurityExpressionOperations createSecurityExpressionRoot(Authentication authentication, MethodInvocation invocation) {
        CustomSecurityExpressionRoot root = new CustomSecurityExpressionRoot(authentication);
        root.setUserReader(this.getUserReader());
        root.setThis(invocation.getThis());
        root.setPermissionEvaluator(this.getPermissionEvaluator());
        root.setTrustResolver(this.getTrustResolver());
        root.setRoleHierarchy(this.getRoleHierarchy());
        root.setDefaultRolePrefix(this.getDefaultRolePrefix());
        return root;
    }

    private UserReader getUserReader() {
        return (UserReader)this.beanFactory.getBean(UserReader.class);
    }
}

