/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.es.backup.es;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.exceptions.TasklistElasticsearchConnectionException;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.util.Either;
import io.camunda.tasklist.util.ElasticsearchUtil;
import io.camunda.tasklist.util.ThreadUtil;
import io.camunda.tasklist.webapp.es.backup.BackupManager;
import io.camunda.tasklist.webapp.es.backup.Metadata;
import io.camunda.tasklist.webapp.management.dto.BackupStateDto;
import io.camunda.tasklist.webapp.management.dto.GetBackupStateResponseDetailDto;
import io.camunda.tasklist.webapp.management.dto.GetBackupStateResponseDto;
import io.camunda.tasklist.webapp.management.dto.TakeBackupRequestDto;
import io.camunda.tasklist.webapp.management.dto.TakeBackupResponseDto;
import io.camunda.tasklist.webapp.rest.exception.InvalidRequestException;
import io.camunda.tasklist.webapp.rest.exception.NotFoundApiException;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.SocketTimeoutException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
@Configuration
@Conditional(value={ElasticSearchCondition.class})
public class BackupManagerElasticSearch
extends BackupManager {
    public static final String SNAPSHOT_MISSING_EXCEPTION_TYPE = "type=snapshot_missing_exception";
    private static final Logger LOGGER = LoggerFactory.getLogger(BackupManagerElasticSearch.class);
    private static final String REPOSITORY_MISSING_EXCEPTION_TYPE = "type=repository_missing_exception";
    @Autowired
    private TasklistProperties tasklistProperties;
    @Autowired
    @Qualifier(value="tasklistEsClient")
    private RestHighLevelClient esClient;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;
    private final Queue<CreateSnapshotRequest> requestsQueue = new ConcurrentLinkedQueue<CreateSnapshotRequest>();
    private final AtomicReference<CreateSnapshotRequest> currentRequest = new AtomicReference<Object>(null);

    @Override
    public void deleteBackup(Long backupId) {
        this.validateRepositoryExists();
        String repositoryName = this.getRepositoryName();
        int count = this.getIndexPatternsOrdered().length;
        String version = this.getCurrentTasklistVersion();
        for (int index = 0; index < count; ++index) {
            String snapshotName = new Metadata().setVersion("*").setPartCount(count).setPartNo(index + 1).setBackupId(backupId).buildSnapshotName();
            DeleteSnapshotRequest request = new DeleteSnapshotRequest(repositoryName);
            request.snapshots(new String[]{snapshotName});
            this.esClient.snapshot().deleteAsync(request, RequestOptions.DEFAULT, this.getDeleteListener());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TakeBackupResponseDto takeBackup(TakeBackupRequestDto request) {
        this.validateRepositoryExists();
        this.validateNoDuplicateBackupId(request.getBackupId());
        if (this.requestsQueue.size() > 0) {
            throw new InvalidRequestException("Another backup is running at the moment");
        }
        Queue<CreateSnapshotRequest> queue = this.requestsQueue;
        synchronized (queue) {
            if (this.requestsQueue.size() > 0) {
                throw new InvalidRequestException("Another backup is running at the moment");
            }
            return this.scheduleSnapshots(request);
        }
    }

    @Override
    public GetBackupStateResponseDto getBackupState(Long backupId) {
        boolean isBackupInProgress = this.isBackupInProgress(backupId);
        List<SnapshotInfo> snapshots = this.findSnapshots(backupId);
        return this.getBackupResponse(backupId, snapshots, isBackupInProgress);
    }

    @Override
    public List<GetBackupStateResponseDto> getBackups(boolean verbose, String pattern) {
        Either<Throwable, String> validatedPattern = BackupManagerElasticSearch.validPattern(pattern);
        validatedPattern.ifLeft(ex -> {
            throw new InvalidRequestException(ex.getMessage(), (Throwable)ex);
        });
        GetSnapshotsRequest snapshotsStatusRequest = new GetSnapshotsRequest().repository(this.getRepositoryName()).snapshots(new String[]{"camunda_tasklist_" + (String)validatedPattern.get()}).verbose(verbose);
        if (verbose) {
            snapshotsStatusRequest = snapshotsStatusRequest.sort(GetSnapshotsRequest.SortBy.START_TIME).order(SortOrder.DESC);
        }
        try {
            GetSnapshotsResponse response = this.esClient.snapshot().get(snapshotsStatusRequest, RequestOptions.DEFAULT);
            List<SnapshotInfo> snapshots = response.getSnapshots();
            if (verbose) {
                snapshots = snapshots.stream().sorted(Comparator.comparing(SnapshotInfo::startTime).reversed()).toList();
            }
            LinkedHashMap groupedSnapshotInfos = snapshots.stream().collect(Collectors.groupingBy(si -> {
                Metadata metadata = Metadata.extractFromMetadataOrName(Metadata.fromObjectMapper(this.objectMapper, si.userMetadata()), si.snapshotId().getName());
                Long backupId = metadata.getBackupId();
                if (backupId == null) {
                    backupId = Metadata.extractBackupIdFromSnapshotName(si.snapshotId().getName());
                }
                return backupId;
            }, LinkedHashMap::new, Collectors.toList()));
            return groupedSnapshotInfos.entrySet().stream().map(entry -> this.getBackupResponse((Long)entry.getKey(), (List)entry.getValue(), this.isBackupInProgress((Long)entry.getKey()))).collect(Collectors.toList());
        }
        catch (IOException | TransportException ex2) {
            String reason = String.format("Encountered an error connecting to Elasticsearch while searching for snapshots. Repository name: [%s].", this.getRepositoryName());
            throw new TasklistElasticsearchConnectionException(reason, ex2);
        }
        catch (Exception e) {
            if (this.isRepositoryMissingException(e)) {
                String reason = String.format("No repository with name [%s] could be found.", this.tasklistProperties.getBackup().getRepositoryName());
                throw new TasklistRuntimeException(reason);
            }
            if (this.isSnapshotMissingException(e)) {
                return new ArrayList<GetBackupStateResponseDto>();
            }
            String reason = String.format("Exception occurred when searching for backups: %s", e.getMessage());
            throw new TasklistRuntimeException(reason, (Throwable)e);
        }
    }

    private ActionListener<AcknowledgedResponse> getDeleteListener() {
        return new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse response) {
                LOGGER.debug("Delete snapshot was acknowledged by Elasticsearch node: " + response.isAcknowledged());
            }

            public void onFailure(Exception e) {
                if (BackupManagerElasticSearch.this.isSnapshotMissingException(e)) {
                    LOGGER.warn("No snapshot found for snapshot deletion: " + e.getMessage());
                } else {
                    LOGGER.error("Exception occurred while deleting the snapshot: " + e.getMessage(), (Throwable)e);
                }
            }
        };
    }

    private boolean isSnapshotMissingException(Exception e) {
        return e instanceof ElasticsearchStatusException && ((ElasticsearchStatusException)e).getDetailedMessage().contains(SNAPSHOT_MISSING_EXCEPTION_TYPE);
    }

    private boolean isRepositoryMissingException(Exception e) {
        return e instanceof ElasticsearchStatusException && ((ElasticsearchStatusException)e).getDetailedMessage().contains(REPOSITORY_MISSING_EXCEPTION_TYPE);
    }

    private TakeBackupResponseDto scheduleSnapshots(TakeBackupRequestDto request) {
        String repositoryName = this.getRepositoryName();
        int count = this.getIndexPatternsOrdered().length;
        ArrayList<String> snapshotNames = new ArrayList<String>();
        String version = this.getCurrentTasklistVersion();
        for (int index = 0; index < count; ++index) {
            String[] indexPattern = this.getIndexPatternsOrdered()[index];
            Metadata metadata = new Metadata().setVersion(version).setPartCount(count).setPartNo(index + 1).setBackupId(request.getBackupId());
            String snapshotName = metadata.buildSnapshotName();
            this.requestsQueue.offer(new CreateSnapshotRequest().repository(repositoryName).snapshot(snapshotName).indices(indexPattern).indicesOptions(ElasticsearchUtil.STRICT_EXPAND_OPEN_CLOSED_IGNORE_THROTTLED).includeGlobalState(true).userMetadata((Map)this.objectMapper.convertValue((Object)metadata, (TypeReference)new TypeReference<Map<String, Object>>(this){})).featureStates(new String[]{"none"}).waitForCompletion(true));
            LOGGER.debug("Snapshot scheduled: " + snapshotName);
            snapshotNames.add(snapshotName);
        }
        this.scheduleNextSnapshot();
        return new TakeBackupResponseDto().setScheduledSnapshots(snapshotNames);
    }

    private void scheduleNextSnapshot() {
        CreateSnapshotRequest nextRequest = this.requestsQueue.poll();
        this.currentRequest.set(nextRequest);
        if (nextRequest != null) {
            this.getTaskExecutor().submit(() -> this.executeSnapshotting(nextRequest));
            LOGGER.debug("Snapshot picked for execution: " + nextRequest.getDescription());
        }
    }

    private void validateRepositoryExists() {
        String repositoryName = this.getRepositoryName();
        GetRepositoriesRequest getRepositoriesRequest = new GetRepositoriesRequest().repositories(new String[]{repositoryName});
        try {
            this.getRepository(getRepositoriesRequest);
        }
        catch (IOException | TransportException ex) {
            String reason = String.format("Encountered an error connecting to Elasticsearch while retrieving repository with name [%s].", repositoryName);
            throw new TasklistElasticsearchConnectionException(reason, ex);
        }
        catch (Exception e) {
            if (this.isRepositoryMissingException(e)) {
                String reason = String.format("No repository with name [%s] could be found.", repositoryName);
                throw new TasklistRuntimeException(reason);
            }
            String reason = String.format("Exception occurred when validating existence of repository with name [%s].", repositoryName);
            throw new TasklistRuntimeException(reason, (Throwable)e);
        }
    }

    private GetRepositoriesResponse getRepository(GetRepositoriesRequest getRepositoriesRequest) throws IOException {
        return this.esClient.snapshot().getRepository(getRepositoriesRequest, RequestOptions.DEFAULT);
    }

    private void validateNoDuplicateBackupId(Long backupId) {
        GetSnapshotsResponse response;
        GetSnapshotsRequest snapshotsStatusRequest = new GetSnapshotsRequest().repository(this.getRepositoryName()).snapshots(new String[]{Metadata.buildSnapshotNamePrefix(backupId) + "*"});
        try {
            response = this.esClient.snapshot().get(snapshotsStatusRequest, RequestOptions.DEFAULT);
        }
        catch (IOException | TransportException ex) {
            String reason = String.format("Encountered an error connecting to Elasticsearch while searching for duplicate backup. Repository name: [%s].", this.getRepositoryName());
            throw new TasklistElasticsearchConnectionException(reason, ex);
        }
        catch (Exception e) {
            if (this.isSnapshotMissingException(e)) {
                return;
            }
            String reason = String.format("Exception occurred when validating whether backup with ID [%s] already exists.", backupId);
            throw new TasklistRuntimeException(reason, (Throwable)e);
        }
        if (!response.getSnapshots().isEmpty()) {
            String reason = String.format("A backup with ID [%s] already exists. Found snapshots: [%s]", backupId, response.getSnapshots().stream().map(snapshotInfo -> snapshotInfo.snapshotId().toString()).collect(Collectors.joining(", ")));
            throw new InvalidRequestException(reason);
        }
    }

    protected void executeSnapshotting(CreateSnapshotRequest snapshotRequest) {
        this.esClient.snapshot().createAsync(snapshotRequest, RequestOptions.DEFAULT, (ActionListener)new CreateSnapshotListener(snapshotRequest));
    }

    /*
     * Unable to fully structure code
     */
    private GetBackupStateResponseDto getBackupResponse(Long backupId, List<SnapshotInfo> snapshots, boolean isBackupInProgress) {
        block15: {
            block17: {
                block16: {
                    block14: {
                        response = new GetBackupStateResponseDto(backupId);
                        metadata = Metadata.extractFromMetadataOrName(Metadata.fromObjectMapper(this.objectMapper, snapshots.getFirst().userMetadata()), snapshots.getFirst().snapshotId().getName());
                        expectedSnapshotsCount = metadata.getPartCount();
                        if (snapshots.size() != expectedSnapshotsCount.intValue()) break block14;
                        if (!snapshots.stream().map((Function<SnapshotInfo, SnapshotState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, state(), (Lorg/elasticsearch/snapshots/SnapshotInfo;)Lorg/elasticsearch/snapshots/SnapshotState;)()).allMatch((Predicate<SnapshotState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lorg/elasticsearch/snapshots/SnapshotState;)Z)((SnapshotState)SnapshotState.SUCCESS))) break block14;
                        response.setState(BackupStateDto.COMPLETED);
                        break block15;
                    }
                    if (!snapshots.stream().map((Function<SnapshotInfo, SnapshotState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, state(), (Lorg/elasticsearch/snapshots/SnapshotInfo;)Lorg/elasticsearch/snapshots/SnapshotState;)()).anyMatch((Predicate<SnapshotState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getBackupResponse$5(org.elasticsearch.snapshots.SnapshotState ), (Lorg/elasticsearch/snapshots/SnapshotState;)Z)())) break block16;
                    response.setState(BackupStateDto.FAILED);
                    break block15;
                }
                if (!snapshots.stream().map((Function<SnapshotInfo, SnapshotState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, state(), (Lorg/elasticsearch/snapshots/SnapshotInfo;)Lorg/elasticsearch/snapshots/SnapshotState;)()).anyMatch((Predicate<SnapshotState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lorg/elasticsearch/snapshots/SnapshotState;)Z)((SnapshotState)SnapshotState.INCOMPATIBLE))) break block17;
                response.setState(BackupStateDto.INCOMPATIBLE);
                break block15;
            }
            if (isBackupInProgress) ** GOTO lbl-1000
            if (snapshots.stream().map((Function<SnapshotInfo, SnapshotState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, state(), (Lorg/elasticsearch/snapshots/SnapshotInfo;)Lorg/elasticsearch/snapshots/SnapshotState;)()).anyMatch((Predicate<SnapshotState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lorg/elasticsearch/snapshots/SnapshotState;)Z)((SnapshotState)SnapshotState.IN_PROGRESS))) lbl-1000:
            // 2 sources

            {
                response.setState(BackupStateDto.IN_PROGRESS);
            } else if (snapshots.size() < expectedSnapshotsCount) {
                response.setState(this.isWithinGracePeriodForIncomplete(snapshots.getLast().endTime()) != false ? BackupStateDto.IN_PROGRESS : BackupStateDto.INCOMPLETE);
            } else {
                response.setState(BackupStateDto.FAILED);
            }
        }
        details = new ArrayList<GetBackupStateResponseDetailDto>();
        for (SnapshotInfo snapshot : snapshots) {
            detail = new GetBackupStateResponseDetailDto();
            detail.setSnapshotName(snapshot.snapshotId().getName());
            if (snapshot.startTime() > 0L) {
                detail.setStartTime(OffsetDateTime.ofInstant(Instant.ofEpochMilli(snapshot.startTime()), ZoneId.systemDefault()));
            }
            if (snapshot.shardFailures() != null) {
                detail.setFailures((String[])snapshot.shardFailures().stream().map((Function<SnapshotShardFailure, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lorg/elasticsearch/snapshots/SnapshotShardFailure;)Ljava/lang/String;)()).toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$getBackupResponse$6(int ), (I)[Ljava/lang/String;)()));
            }
            detail.setState(snapshot.state().name());
            details.add(detail);
        }
        response.setDetails(details);
        if (response.getState().equals((Object)BackupStateDto.FAILED)) {
            failureReason = null;
            failedSnapshots = snapshots.stream().filter((Predicate<SnapshotInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getBackupResponse$7(org.elasticsearch.snapshots.SnapshotInfo ), (Lorg/elasticsearch/snapshots/SnapshotInfo;)Z)()).map((Function<SnapshotInfo, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getBackupResponse$8(org.elasticsearch.snapshots.SnapshotInfo ), (Lorg/elasticsearch/snapshots/SnapshotInfo;)Ljava/lang/String;)()).collect(Collectors.joining(", "));
            if (!failedSnapshots.isEmpty()) {
                failureReason = String.format("There were failures with the following snapshots: %s", new Object[]{failedSnapshots});
            } else {
                partialSnapshot = snapshots.stream().filter((Predicate<SnapshotInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getBackupResponse$9(org.elasticsearch.snapshots.SnapshotInfo ), (Lorg/elasticsearch/snapshots/SnapshotInfo;)Z)()).map((Function<SnapshotInfo, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getBackupResponse$10(org.elasticsearch.snapshots.SnapshotInfo ), (Lorg/elasticsearch/snapshots/SnapshotInfo;)Ljava/lang/String;)()).collect(Collectors.joining(", "));
                if (!partialSnapshot.isEmpty()) {
                    failureReason = String.format("Some of the snapshots are partial: %s", new Object[]{partialSnapshot});
                } else if (snapshots.size() > expectedSnapshotsCount) {
                    failureReason = "More snapshots found than expected.";
                }
            }
            if (failureReason != null) {
                response.setFailureReason(failureReason);
            }
        }
        return response;
    }

    private boolean isWithinGracePeriodForIncomplete(long lastSnapshotFinishedTime) {
        long incompleteCheckTimeoutInMilliseconds = this.tasklistProperties.getBackup().getIncompleteCheckTimeoutInSeconds() * 1000L;
        try {
            return Instant.now().toEpochMilli() - lastSnapshotFinishedTime < incompleteCheckTimeoutInMilliseconds;
        }
        catch (Exception e) {
            LOGGER.warn("Couldn't check incomplete timeout for backup. Return incomplete check is timed out", (Throwable)e);
            return true;
        }
    }

    private List<SnapshotInfo> findSnapshots(Long backupId) {
        GetSnapshotsRequest snapshotsStatusRequest = new GetSnapshotsRequest().repository(this.getRepositoryName()).snapshots(new String[]{Metadata.buildSnapshotNamePrefix(backupId) + "*"});
        try {
            GetSnapshotsResponse response = this.esClient.snapshot().get(snapshotsStatusRequest, RequestOptions.DEFAULT);
            return response.getSnapshots();
        }
        catch (IOException | TransportException ex) {
            String reason = String.format("Encountered an error connecting to Elasticsearch while searching for snapshots. Repository name: [%s].", this.getRepositoryName());
            throw new TasklistElasticsearchConnectionException(reason, ex);
        }
        catch (Exception e) {
            if (this.isSnapshotMissingException(e)) {
                throw new NotFoundApiException(String.format("No backup with id [%s] found.", backupId), e);
            }
            if (this.isRepositoryMissingException(e)) {
                String reason = String.format("No repository with name [%s] could be found.", this.tasklistProperties.getBackup().getRepositoryName());
                throw new TasklistRuntimeException(reason);
            }
            String reason = String.format("Exception occurred when searching for backup with ID [%s].", backupId);
            throw new TasklistRuntimeException(reason, (Throwable)e);
        }
    }

    @Bean(value={"tasklistBackupThreadPoolExecutor"})
    public ThreadPoolTaskExecutor getTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(1);
        executor.setMaxPoolSize(1);
        executor.setThreadNamePrefix("backup_es_");
        executor.setQueueCapacity(6);
        executor.initialize();
        return executor;
    }

    protected boolean isSnapshotFinishedWithinTimeout(String snapshotName) {
        int count = 0;
        long startTime = System.currentTimeMillis();
        int snapshotTimeout = this.tasklistProperties.getBackup().getSnapshotTimeout();
        long backupId = Metadata.extractBackupIdFromSnapshotName(snapshotName);
        while (snapshotTimeout == 0 || System.currentTimeMillis() - startTime <= (long)(snapshotTimeout * 1000)) {
            List<SnapshotInfo> snapshotInfos = this.findSnapshots(backupId);
            SnapshotInfo currentSnapshot = snapshotInfos.stream().filter(x -> Objects.equals(x.snapshotId().getName(), snapshotName)).findFirst().orElse(null);
            if (currentSnapshot == null) {
                LOGGER.error(String.format("Expected (but not found) snapshot [%s] for backupId [%d].", snapshotName, backupId));
                return false;
            }
            if (currentSnapshot.state() == SnapshotState.IN_PROGRESS) {
                ThreadUtil.sleepFor((long)100L);
                if (++count % 600 != 0) continue;
                LOGGER.info(String.format("Waiting for snapshot [%s] to finish.", snapshotName));
                continue;
            }
            return this.isSnapshotFinished(currentSnapshot);
        }
        LOGGER.error(String.format("Snapshot [%s] did not finish after configured timeout. Snapshot process won't continue.", snapshotName));
        return false;
    }

    private boolean isSnapshotFinished(SnapshotInfo snapshotInfo) {
        SnapshotState snapshotState = snapshotInfo.state();
        SnapshotId snapshotId = snapshotInfo.snapshotId();
        switch (snapshotState) {
            case SUCCESS: {
                LOGGER.info("Snapshot done: {}", (Object)snapshotId);
                return true;
            }
            case FAILED: {
                LOGGER.error("Snapshot failed for {}, reason {}", (Object)snapshotId, (Object)snapshotInfo.reason());
                return false;
            }
        }
        LOGGER.error("Unexpected snapshot state '{}' for {}", (Object)snapshotState, (Object)snapshotId);
        return false;
    }

    private boolean isBackupInProgress(Long backupId) {
        return Stream.concat(Stream.ofNullable(this.currentRequest.get()), this.requestsQueue.stream()).anyMatch(request -> backupId.equals(Metadata.fromObjectMapper(this.objectMapper, request.userMetadata()).getBackupId()));
    }

    private static /* synthetic */ String lambda$getBackupResponse$10(SnapshotInfo s) {
        return s.snapshotId().getName();
    }

    private static /* synthetic */ boolean lambda$getBackupResponse$9(SnapshotInfo s) {
        return s.state().equals((Object)SnapshotState.PARTIAL);
    }

    private static /* synthetic */ String lambda$getBackupResponse$8(SnapshotInfo s) {
        return s.snapshotId().getName();
    }

    private static /* synthetic */ boolean lambda$getBackupResponse$7(SnapshotInfo s) {
        return s.state().equals((Object)SnapshotState.FAILED);
    }

    private static /* synthetic */ String[] lambda$getBackupResponse$6(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ boolean lambda$getBackupResponse$5(SnapshotState s) {
        return SnapshotState.FAILED.equals((Object)s) || SnapshotState.PARTIAL.equals((Object)s);
    }

    public class CreateSnapshotListener
    implements ActionListener<CreateSnapshotResponse> {
        private final CreateSnapshotRequest snapshotRequest;
        private final Runnable onSuccess;
        private final Runnable onFailure;

        public CreateSnapshotListener(CreateSnapshotRequest snapshotRequest) {
            this.snapshotRequest = snapshotRequest;
            this.onSuccess = () -> BackupManagerElasticSearch.this.scheduleNextSnapshot();
            this.onFailure = () -> {
                BackupManagerElasticSearch.this.currentRequest.set(null);
                BackupManagerElasticSearch.this.requestsQueue.clear();
            };
        }

        public void onResponse(CreateSnapshotResponse response) {
            if (BackupManagerElasticSearch.this.isSnapshotFinished(response.getSnapshotInfo())) {
                this.onSuccess.run();
            } else {
                this.onFailure.run();
            }
        }

        public void onFailure(Exception e) {
            if (e instanceof SocketTimeoutException) {
                int snapshotTimeout = BackupManagerElasticSearch.this.tasklistProperties.getBackup().getSnapshotTimeout();
                LOGGER.warn(String.format("Socket timeout while creating snapshot [%s]. Start waiting with polling timeout, %s", this.snapshotRequest.snapshot(), this.snapshotRequest.userMetadata().get("backupId"), snapshotTimeout == 0 ? "until completion." : "at most " + snapshotTimeout + " seconds."));
                if (BackupManagerElasticSearch.this.isSnapshotFinishedWithinTimeout(this.snapshotRequest.snapshot())) {
                    this.onSuccess.run();
                } else {
                    this.onFailure.run();
                }
            } else {
                LOGGER.error("Exception occurred while creating snapshot: " + e.getMessage(), (Throwable)e);
                this.onFailure.run();
            }
        }
    }
}

