/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.config.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class LoggingFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        long startTime = System.currentTimeMillis();
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.info("Request Processed: Method={}, URI={}, Response Code={}, Time Taken={} ms", new Object[]{request.getMethod(), request.getRequestURI(), response.getStatus(), timeTaken});
    }
}

